/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template.macro;

import ai.grakn.graql.macro.Macro;
import java.util.List;

public class LongMacro
implements Macro<Long> {
    private static final int numberArguments = 1;

    public Long apply(List<Object> values) {
        if (values.size() != 1) {
            throw new IllegalArgumentException("Wrong number of arguments [" + values.size() + "] to macro " + this.name());
        }
        String longValue = values.get(0).toString();
        try {
            return Long.parseLong(longValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value [" + longValue + "] is not a long in macro " + this.name());
        }
    }

    public String name() {
        return "long";
    }
}

