/*
 * Grakn - A Distributed Semantic Database
 * Copyright (C) 2016  Grakn Labs Limited
 *
 * Grakn is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Grakn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Grakn. If not, see <http://www.gnu.org/licenses/gpl.txt>.
 */

package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.graql.ComputeQueryBuilder;
import ai.grakn.graql.analytics.ClusterQuery;
import ai.grakn.graql.analytics.CountQuery;
import ai.grakn.graql.analytics.DegreeQuery;
import ai.grakn.graql.analytics.MaxQuery;
import ai.grakn.graql.analytics.MeanQuery;
import ai.grakn.graql.analytics.MedianQuery;
import ai.grakn.graql.analytics.MinQuery;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.analytics.StdQuery;
import ai.grakn.graql.analytics.SumQuery;

import java.util.Map;
import java.util.Optional;

/**
 * This class implements ComputeQueryBuilder.
 * <p>
 *
 * @author Jason Liu
 * @author Sheldon Hall
 */

public class ComputeQueryBuilderImpl implements ComputeQueryBuilder {

    private Optional<GraknTx> tx;

    public ComputeQueryBuilderImpl(Optional<GraknTx> tx) {
        this.tx = tx;
    }

    @Override
    public ComputeQueryBuilder withTx(GraknTx tx) {
        this.tx = Optional.of(tx);
        return this;
    }

    @Override
    public CountQuery count() {
        return new CountQueryImpl(tx);
    }

    @Override
    public MinQuery min() {
        return new MinQueryImpl(tx);
    }

    @Override
    public MaxQuery max() {
        return new MaxQueryImpl(tx);
    }

    @Override
    public SumQuery sum() {
        return new SumQueryImpl(tx);
    }

    @Override
    public MeanQuery mean() {
        return new MeanQueryImpl(tx);
    }

    @Override
    public StdQuery std() {
        return new StdQueryImpl(tx);
    }

    @Override
    public MedianQuery median() {
        return new MedianQueryImpl(tx);
    }

    @Override
    public PathQuery path() {
        return new PathQueryImpl(tx);
    }

    @Override
    public ClusterQuery<Map<String, Long>> cluster() {
        return new ClusterQueryImpl<>(tx);
    }

    @Override
    public DegreeQuery degree() {
        return new DegreeQueryImpl(tx);
    }
}
