/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.ComputeQueryBuilder;
import ai.grakn.graql.DefineQuery;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.NamedAggregate;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.UndefineQuery;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.graql.internal.query.predicate.Predicates;
import ai.grakn.graql.internal.util.AdminConverter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;

public class Graql {
    private Graql() {
    }

    @CheckReturnValue
    public static QueryBuilder withoutGraph() {
        return new QueryBuilderImpl();
    }

    @CheckReturnValue
    public static Match match(Pattern ... patterns) {
        return Graql.withoutGraph().match(patterns);
    }

    @CheckReturnValue
    public static Match match(Collection<? extends Pattern> patterns) {
        return Graql.withoutGraph().match(patterns);
    }

    @CheckReturnValue
    public static InsertQuery insert(VarPattern ... varPatterns) {
        return Graql.withoutGraph().insert(varPatterns);
    }

    @CheckReturnValue
    public static InsertQuery insert(Collection<? extends VarPattern> varPatterns) {
        return Graql.withoutGraph().insert(varPatterns);
    }

    @CheckReturnValue
    public static DefineQuery define(VarPattern ... varPatterns) {
        return Graql.withoutGraph().define(varPatterns);
    }

    @CheckReturnValue
    public static DefineQuery define(Collection<? extends VarPattern> varPatterns) {
        return Graql.withoutGraph().define(varPatterns);
    }

    @CheckReturnValue
    public static UndefineQuery undefine(VarPattern ... varPatterns) {
        return Graql.withoutGraph().undefine(varPatterns);
    }

    @CheckReturnValue
    public static UndefineQuery undefine(Collection<? extends VarPattern> varPatterns) {
        return Graql.withoutGraph().undefine(varPatterns);
    }

    @CheckReturnValue
    public static ComputeQueryBuilder compute() {
        return Graql.withoutGraph().compute();
    }

    @CheckReturnValue
    public static List<Pattern> parsePatterns(String patternsString) {
        return Graql.withoutGraph().parsePatterns(patternsString);
    }

    @CheckReturnValue
    public static <T extends Query<?>> T parse(String queryString) {
        return (T)Graql.withoutGraph().parse(queryString);
    }

    @CheckReturnValue
    public static Stream<Query<?>> parseList(String queryString) {
        return Graql.withoutGraph().parseList(queryString);
    }

    @CheckReturnValue
    public static <T extends Query<?>> Stream<T> parseTemplate(String template, Map<String, Object> data) {
        return Graql.withoutGraph().parseTemplate(template, data);
    }

    @CheckReturnValue
    public static Var var(String name) {
        return Patterns.var(name);
    }

    @CheckReturnValue
    public static Var var() {
        return Patterns.var();
    }

    @CheckReturnValue
    public static VarPattern label(Label label) {
        return Graql.var().label(label);
    }

    @CheckReturnValue
    public static VarPattern label(String label) {
        return Graql.var().label(label);
    }

    @CheckReturnValue
    public static Pattern and(Pattern ... patterns) {
        return Graql.and(Arrays.asList(patterns));
    }

    @CheckReturnValue
    public static Pattern and(Collection<? extends Pattern> patterns) {
        Collection<PatternAdmin> patternAdmins = AdminConverter.getPatternAdmins(patterns);
        return Patterns.conjunction(Sets.newHashSet(patternAdmins));
    }

    @CheckReturnValue
    public static Pattern or(Pattern ... patterns) {
        return Graql.or(Arrays.asList(patterns));
    }

    @CheckReturnValue
    public static Pattern or(Collection<? extends Pattern> patterns) {
        Collection<PatternAdmin> patternAdmins = AdminConverter.getPatternAdmins(patterns);
        return Patterns.disjunction(Sets.newHashSet(patternAdmins));
    }

    @CheckReturnValue
    public static Aggregate<Object, Boolean> ask() {
        return Aggregates.ask();
    }

    @CheckReturnValue
    public static Aggregate<Object, Long> count() {
        return Aggregates.count();
    }

    @CheckReturnValue
    public static Aggregate<Answer, Number> sum(String var) {
        return Aggregates.sum(Graql.var(var));
    }

    @CheckReturnValue
    public static <T extends Comparable<T>> Aggregate<Answer, Optional<T>> max(String var) {
        return Aggregates.max(Graql.var(var));
    }

    @CheckReturnValue
    public static <T extends Comparable<T>> Aggregate<Answer, Optional<T>> min(String var) {
        return Aggregates.min(Graql.var(var));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Optional<Double>> mean(String var) {
        return Aggregates.mean(Graql.var(var));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Optional<Number>> median(String var) {
        return Aggregates.median(Graql.var(var));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Optional<Double>> std(String var) {
        return Aggregates.std(Graql.var(var));
    }

    @CheckReturnValue
    public static Aggregate<Answer, Map<Concept, List<Answer>>> group(String var) {
        return Graql.group(var, Aggregates.list());
    }

    @CheckReturnValue
    public static <T> Aggregate<Answer, Map<Concept, T>> group(String var, Aggregate<? super Answer, T> aggregate) {
        return Aggregates.group(Graql.var(var), aggregate);
    }

    @CheckReturnValue
    @SafeVarargs
    public static <S, T> Aggregate<S, Map<String, T>> select(NamedAggregate<? super S, ? extends T> ... aggregates) {
        return Graql.select(ImmutableSet.copyOf((Object[])aggregates));
    }

    @CheckReturnValue
    public static <S, T> Aggregate<S, Map<String, T>> select(Set<NamedAggregate<? super S, ? extends T>> aggregates) {
        return Aggregates.select(ImmutableSet.copyOf(aggregates));
    }

    @CheckReturnValue
    public static ValuePredicate eq(Object value) {
        Objects.requireNonNull(value);
        return Predicates.eq(value);
    }

    @CheckReturnValue
    public static ValuePredicate eq(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.eq(varPattern);
    }

    @CheckReturnValue
    public static ValuePredicate neq(Object value) {
        Objects.requireNonNull(value);
        return Predicates.neq(value);
    }

    @CheckReturnValue
    public static ValuePredicate neq(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.neq(varPattern);
    }

    @CheckReturnValue
    public static ValuePredicate gt(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.gt(value);
    }

    @CheckReturnValue
    public static ValuePredicate gt(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.gt(varPattern);
    }

    @CheckReturnValue
    public static ValuePredicate gte(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.gte(value);
    }

    @CheckReturnValue
    public static ValuePredicate gte(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.gte(varPattern);
    }

    @CheckReturnValue
    public static ValuePredicate lt(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.lt(value);
    }

    @CheckReturnValue
    public static ValuePredicate lt(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.lt(varPattern);
    }

    @CheckReturnValue
    public static ValuePredicate lte(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.lte(value);
    }

    @CheckReturnValue
    public static ValuePredicate lte(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.lte(varPattern);
    }

    @CheckReturnValue
    public static ValuePredicate regex(String pattern) {
        Objects.requireNonNull(pattern);
        return Predicates.regex(pattern);
    }

    @CheckReturnValue
    public static ValuePredicate contains(String substring) {
        Objects.requireNonNull(substring);
        return Predicates.contains(substring);
    }

    @CheckReturnValue
    public static ValuePredicate contains(VarPattern varPattern) {
        Objects.requireNonNull(varPattern);
        return Predicates.contains(varPattern.admin());
    }
}

