/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.util.CommonUtil;
import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CountVertexProgram
extends GraknVertexProgram<Long> {
    public static final String EDGE_COUNT = "countVertexProgram.edgeCount";

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Collections.singleton(VertexComputeKey.of((String)EDGE_COUNT, (boolean)false));
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return memory.isInitialIteration() ? messageScopeSetInAndOut : Collections.emptySet();
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)1L);
                break;
            }
            case 1: {
                if (!messenger.receiveMessages().hasNext()) break;
                vertex.property(EDGE_COUNT, (Object)CountVertexProgram.getMessageCount(messenger));
                break;
            }
            default: {
                throw CommonUtil.unreachableStatement((String)"Exceeded expected maximum number of iterations");
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Count Iteration " + memory.getIteration());
        return memory.getIteration() == 1;
    }
}

