/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeDistributionMapReduce
extends GraknMapReduce<Set<String>> {
    public DegreeDistributionMapReduce() {
    }

    public DegreeDistributionMapReduce(Set<LabelId> selectedLabelIds, String degreePropertyKey) {
        super(selectedLabelIds);
        this.persistentProperties.put("degreeVertexProgram.degree", degreePropertyKey);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Set<String>> emitter) {
        if (this.selectedTypes.isEmpty() || Utility.vertexHasSelectedTypeId(vertex, this.selectedTypes)) {
            emitter.emit(vertex.value((String)this.persistentProperties.get("degreeVertexProgram.degree")), Collections.singleton(vertex.value(Schema.VertexProperty.ID.name())));
        } else {
            emitter.emit((Object)MapReduce.NullObject.instance(), Collections.emptySet());
        }
    }

    @Override
    Set<String> reduceValues(Iterator<Set<String>> values) {
        return Utility.reduceSet(values);
    }

    @Override
    public Map<Serializable, Set<String>> generateFinalResult(Iterator<KeyValue<Serializable, Set<String>>> keyValues) {
        Map<Serializable, Set<String>> clusterPopulation = Utility.keyValuesToMap(keyValues);
        clusterPopulation.remove(MapReduce.NullObject.instance());
        return clusterPopulation;
    }
}

