/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.CommonUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeVertexProgram
extends GraknVertexProgram<Long> {
    public static final String DEGREE = "degreeVertexProgram.degree";
    private static final String OF_LABELS = "degreeVertexProgram.ofLabelIds";
    Set<LabelId> ofLabelIds = new HashSet<LabelId>();

    public DegreeVertexProgram() {
    }

    public DegreeVertexProgram(Set<LabelId> ofLabelIds) {
        this.ofLabelIds = ofLabelIds;
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.ofLabelIds.forEach(type -> configuration.addProperty("degreeVertexProgram.ofLabelIds." + type, type));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(OF_LABELS).getKeys().forEachRemaining(key -> this.ofLabelIds.add((LabelId)configuration.getProperty("degreeVertexProgram.ofLabelIds." + key)));
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Collections.singleton(VertexComputeKey.of((String)DEGREE, (boolean)false));
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return memory.isInitialIteration() ? messageScopeSetInAndOut : Collections.emptySet();
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                this.degreeMessagePassing(messenger);
                break;
            }
            case 1: {
                this.degreeMessageCounting(messenger, vertex);
                break;
            }
            default: {
                throw CommonUtil.unreachableStatement((String)"Exceeded expected maximum number of iterations");
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Degree Iteration " + memory.getIteration());
        return memory.getIteration() == 1;
    }

    private void degreeMessagePassing(Messenger<Long> messenger) {
        messenger.sendMessage((MessageScope)messageScopeIn, (Object)1L);
        messenger.sendMessage((MessageScope)messageScopeOut, (Object)1L);
    }

    private void degreeMessageCounting(Messenger<Long> messenger, Vertex vertex) {
        if (this.ofLabelIds.isEmpty() || Utility.vertexHasSelectedTypeId(vertex, this.ofLabelIds)) {
            vertex.property(DEGREE, (Object)DegreeVertexProgram.getMessageCount(messenger));
        }
    }
}

