/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.CommonOLAP;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class GraknMapReduce<T>
extends CommonOLAP
implements MapReduce<Serializable, T, Serializable, T, Map<Serializable, T>> {
    private static final String RESOURCE_DATA_TYPE_KEY = "RESOURCE_DATA_TYPE_KEY";
    public static final int RESERVED_TYPE_LABEL_KEY = -10;

    GraknMapReduce(Set<LabelId> selectedTypes) {
        this.selectedTypes = selectedTypes;
    }

    GraknMapReduce(Set<LabelId> selectedTypes, AttributeType.DataType resourceDataType) {
        this(selectedTypes);
        this.persistentProperties.put(RESOURCE_DATA_TYPE_KEY, resourceDataType.getName());
    }

    GraknMapReduce() {
    }

    abstract void safeMap(Vertex var1, MapReduce.MapEmitter<Serializable, T> var2);

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty("gremlin.mapReduce", (Object)this.getClass().getName());
    }

    public final void map(Vertex vertex, MapReduce.MapEmitter<Serializable, T> emitter) {
        if (Utility.isAlive(vertex)) {
            this.safeMap(vertex, emitter);
        }
    }

    public final void reduce(Serializable key, Iterator<T> values, MapReduce.ReduceEmitter<Serializable, T> emitter) {
        emitter.emit((Object)key, this.reduceValues(values));
    }

    abstract T reduceValues(Iterator<T> var1);

    public String getMemoryKey() {
        return this.getClass().getName();
    }

    public MapReduce<Serializable, T, Serializable, T, Map<Serializable, T>> clone() {
        try {
            return (GraknMapReduce)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw CommonUtil.unreachableStatement((Throwable)e);
        }
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    public final void combine(Serializable key, Iterator<T> values, MapReduce.ReduceEmitter<Serializable, T> emitter) {
        this.reduce(key, values, emitter);
    }

    public Map<Serializable, T> generateFinalResult(Iterator<KeyValue<Serializable, T>> iterator) {
        return Utility.keyValuesToMap(iterator);
    }

    final Number resourceValue(Vertex vertex) {
        return this.usingLong() ? (Number)((Number)vertex.value(Schema.VertexProperty.VALUE_LONG.name())) : (Number)((Number)vertex.value(Schema.VertexProperty.VALUE_DOUBLE.name()));
    }

    final Number minValue() {
        return this.usingLong() ? -9.223372036854776E18 : Double.MIN_VALUE;
    }

    final Number maxValue() {
        return this.usingLong() ? 9.223372036854776E18 : Double.MAX_VALUE;
    }

    final boolean usingLong() {
        return this.persistentProperties.get(RESOURCE_DATA_TYPE_KEY).equals(AttributeType.DataType.LONG.getName());
    }
}

