/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.StatisticsMapReduce;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MeanMapReduce
extends StatisticsMapReduce<Map<String, Double>> {
    public static final String COUNT = "C";
    public static final String SUM = "S";

    public MeanMapReduce() {
    }

    public MeanMapReduce(Set<LabelId> selectedLabelIds, AttributeType.DataType resourceDataType, String degreeKey) {
        super(selectedLabelIds, resourceDataType, degreeKey);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Map<String, Double>> emitter) {
        if (this.resourceIsValid(vertex)) {
            HashMap<String, Double> tuple = new HashMap<String, Double>(2);
            Double degree = ((Long)vertex.value(this.degreePropertyKey)).doubleValue();
            tuple.put(SUM, degree * this.resourceValue(vertex).doubleValue());
            tuple.put(COUNT, degree);
            emitter.emit((Object)MapReduce.NullObject.instance(), tuple);
            return;
        }
        HashMap<String, Double> emptyTuple = new HashMap<String, Double>(2);
        emptyTuple.put(SUM, 0.0);
        emptyTuple.put(COUNT, 0.0);
        emitter.emit((Object)MapReduce.NullObject.instance(), emptyTuple);
    }

    @Override
    Map<String, Double> reduceValues(Iterator<Map<String, Double>> values) {
        HashMap<String, Double> emptyTuple = new HashMap<String, Double>(2);
        emptyTuple.put(SUM, 0.0);
        emptyTuple.put(COUNT, 0.0);
        return (Map)IteratorUtils.reduce(values, emptyTuple, (a, b) -> {
            a.put(COUNT, (Double)a.get(COUNT) + (Double)b.get(COUNT));
            a.put(SUM, (Double)a.get(SUM) + (Double)b.get(SUM));
            return a;
        });
    }
}

