/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class MedianVertexProgram
extends GraknVertexProgram<Long> {
    private static final int MAX_ITERATION = 40;
    public static final String MEDIAN = "medianVertexProgram.median";
    private static final String RESOURCE_DATA_TYPE = "medianVertexProgram.resourceDataType";
    private static final String RESOURCE_TYPE = "medianVertexProgram.statisticsResourceType";
    private static final String LABEL = "medianVertexProgram.label";
    private static final String COUNT = "medianVertexProgram.count";
    private static final String INDEX_START = "medianVertexProgram.indexStart";
    private static final String INDEX_END = "medianVertexProgram.indexEnd";
    private static final String INDEX_MEDIAN = "medianVertexProgram.indexMedian";
    private static final String PIVOT = "medianVertexProgram.pivot";
    private static final String PIVOT_POSITIVE = "medianVertexProgram.pivotPositive";
    private static final String PIVOT_NEGATIVE = "medianVertexProgram.pivotNegative";
    private static final String POSITIVE_COUNT = "medianVertexProgram.positiveCount";
    private static final String NEGATIVE_COUNT = "medianVertexProgram.negativeCount";
    private static final String FOUND = "medianVertexProgram.found";
    private static final String LABEL_SELECTED = "medianVertexProgram.labelSelected";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new MemoryComputeKey[]{MemoryComputeKey.of((String)"medianVertexProgram.median", (BinaryOperator)Operator.assign, (boolean)false, (boolean)false), MemoryComputeKey.of((String)"medianVertexProgram.labelSelected", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.found", (BinaryOperator)Operator.assign, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.indexStart", (BinaryOperator)Operator.assign, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.indexEnd", (BinaryOperator)Operator.assign, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.indexMedian", (BinaryOperator)Operator.assign, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.count", (BinaryOperator)Operator.sumLong, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.positiveCount", (BinaryOperator)Operator.sumLong, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.negativeCount", (BinaryOperator)Operator.sumLong, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.pivot", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.pivotPositive", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"medianVertexProgram.pivotNegative", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true)});
    private Set<LabelId> statisticsResourceLabelIds = new HashSet<LabelId>();

    public MedianVertexProgram() {
    }

    public MedianVertexProgram(Set<LabelId> statisticsResourceLabelIds, AttributeType.DataType resourceDataType) {
        this.statisticsResourceLabelIds = statisticsResourceLabelIds;
        String resourceDataTypeValue = resourceDataType.equals(AttributeType.DataType.LONG) ? Schema.VertexProperty.VALUE_LONG.name() : Schema.VertexProperty.VALUE_DOUBLE.name();
        this.persistentProperties.put(RESOURCE_DATA_TYPE, resourceDataTypeValue);
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Sets.newHashSet((Object[])new VertexComputeKey[]{VertexComputeKey.of((String)"degreeVertexProgram.degree", (boolean)true), VertexComputeKey.of((String)LABEL, (boolean)true)});
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                return Sets.newHashSet((Object[])new MessageScope[]{messageScopeShortcutIn, messageScopeResourceOut});
            }
            case 1: {
                return Collections.singleton(messageScopeShortcutOut);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.statisticsResourceLabelIds.forEach(typeId -> configuration.addProperty("medianVertexProgram.statisticsResourceType." + typeId, typeId));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(RESOURCE_TYPE).getKeys().forEachRemaining(key -> this.statisticsResourceLabelIds.add((LabelId)configuration.getProperty("medianVertexProgram.statisticsResourceType." + key)));
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("MedianVertexProgram Started !!!!!!!!");
        memory.set(COUNT, (Object)0L);
        memory.set(LABEL_SELECTED, (Object)memory.getIteration());
        memory.set(NEGATIVE_COUNT, (Object)0L);
        memory.set(POSITIVE_COUNT, (Object)0L);
        memory.set(FOUND, (Object)false);
        if (this.persistentProperties.get(RESOURCE_DATA_TYPE).equals(Schema.VertexProperty.VALUE_LONG.name())) {
            memory.set(MEDIAN, (Object)0L);
            memory.set(PIVOT, (Object)0L);
            memory.set(PIVOT_NEGATIVE, (Object)0L);
            memory.set(PIVOT_POSITIVE, (Object)0L);
        } else {
            memory.set(MEDIAN, (Object)0.0);
            memory.set(PIVOT, (Object)0.0);
            memory.set(PIVOT_NEGATIVE, (Object)0.0);
            memory.set(PIVOT_POSITIVE, (Object)0.0);
        }
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepResourceOwner(vertex, messenger, this.statisticsResourceLabelIds);
                break;
            }
            case 1: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepResourceRelation(vertex, messenger, this.statisticsResourceLabelIds);
                break;
            }
            case 2: {
                if (!Utility.vertexHasSelectedTypeId(vertex, this.statisticsResourceLabelIds)) break;
                long degree = vertex.property("degreeVertexProgram.degree").isPresent() ? MedianVertexProgram.getMessageCount(messenger) + (Long)vertex.value("degreeVertexProgram.degree") : MedianVertexProgram.getMessageCount(messenger);
                vertex.property("degreeVertexProgram.degree", (Object)degree);
                if (degree <= 0L) break;
                memory.add(PIVOT, vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE)));
                memory.add(COUNT, (Object)degree);
                break;
            }
            case 3: {
                if (!Utility.vertexHasSelectedTypeId(vertex, this.statisticsResourceLabelIds) || (Long)vertex.value("degreeVertexProgram.degree") <= 0L) break;
                Number value = (Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE));
                if (value.doubleValue() < ((Number)memory.get(PIVOT)).doubleValue()) {
                    this.updateMemoryNegative(vertex, memory, value);
                    break;
                }
                if (value.doubleValue() > ((Number)memory.get(PIVOT)).doubleValue()) {
                    this.updateMemoryPositive(vertex, memory, value);
                    break;
                }
                vertex.property(LABEL, (Object)0);
                break;
            }
            default: {
                if (!Utility.vertexHasSelectedTypeId(vertex, this.statisticsResourceLabelIds) || (Long)vertex.value("degreeVertexProgram.degree") <= 0L || ((Integer)vertex.value(LABEL)).intValue() != ((Integer)memory.get(LABEL_SELECTED)).intValue()) break;
                Number value = (Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE));
                if (value.doubleValue() < ((Number)memory.get(PIVOT)).doubleValue()) {
                    this.updateMemoryNegative(vertex, memory, value);
                    break;
                }
                if (!(value.doubleValue() > ((Number)memory.get(PIVOT)).doubleValue())) break;
                this.updateMemoryPositive(vertex, memory, value);
            }
        }
    }

    private void updateMemoryPositive(Vertex vertex, Memory memory, Number value) {
        vertex.property(LABEL, (Object)memory.getIteration());
        memory.add(POSITIVE_COUNT, vertex.value("degreeVertexProgram.degree"));
        memory.add(PIVOT_POSITIVE, (Object)value);
    }

    private void updateMemoryNegative(Vertex vertex, Memory memory, Number value) {
        vertex.property(LABEL, (Object)(-memory.getIteration()));
        memory.add(NEGATIVE_COUNT, vertex.value("degreeVertexProgram.degree"));
        memory.add(PIVOT_NEGATIVE, (Object)value);
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() == 2) {
            memory.set(INDEX_START, (Object)0L);
            memory.set(INDEX_END, (Object)((Long)memory.get(COUNT) - 1L));
            memory.set(INDEX_MEDIAN, (Object)(((Long)memory.get(COUNT) - 1L) / 2L));
            LOGGER.debug("count: " + memory.get(COUNT));
            LOGGER.debug("first pivot: " + memory.get(PIVOT));
        } else if (memory.getIteration() > 2) {
            long indexNegativeEnd = (Long)memory.get(INDEX_START) + (Long)memory.get(NEGATIVE_COUNT) - 1L;
            long indexPositiveStart = (Long)memory.get(INDEX_END) - (Long)memory.get(POSITIVE_COUNT) + 1L;
            LOGGER.debug("pivot: " + memory.get(PIVOT));
            LOGGER.debug(memory.get(INDEX_START) + ", " + indexNegativeEnd);
            LOGGER.debug(indexPositiveStart + ", " + memory.get(INDEX_END));
            LOGGER.debug("negative count: " + memory.get(NEGATIVE_COUNT));
            LOGGER.debug("positive count: " + memory.get(POSITIVE_COUNT));
            LOGGER.debug("negative pivot: " + memory.get(PIVOT_NEGATIVE));
            LOGGER.debug("positive pivot: " + memory.get(PIVOT_POSITIVE));
            if (indexNegativeEnd < (Long)memory.get(INDEX_MEDIAN)) {
                if (indexPositiveStart > (Long)memory.get(INDEX_MEDIAN)) {
                    memory.set(FOUND, (Object)true);
                    LOGGER.debug("FOUND IT!!!");
                } else {
                    memory.set(INDEX_START, (Object)indexPositiveStart);
                    memory.set(PIVOT, memory.get(PIVOT_POSITIVE));
                    memory.set(LABEL_SELECTED, (Object)memory.getIteration());
                    LOGGER.debug("new pivot: " + memory.get(PIVOT));
                }
            } else {
                memory.set(INDEX_END, (Object)indexNegativeEnd);
                memory.set(PIVOT, memory.get(PIVOT_NEGATIVE));
                memory.set(LABEL_SELECTED, (Object)(-memory.getIteration()));
                LOGGER.debug("new pivot: " + memory.get(PIVOT));
            }
            memory.set(MEDIAN, memory.get(PIVOT));
            memory.set(POSITIVE_COUNT, (Object)0L);
            memory.set(NEGATIVE_COUNT, (Object)0L);
        }
        return (Boolean)memory.get(FOUND) != false || memory.getIteration() >= 40;
    }
}

