/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;
import org.javatuples.Tuple;

public class ShortestPathVertexProgram
extends GraknVertexProgram<Tuple> {
    private static final int MAX_ITERATION = 50;
    public static final String FOUND_IN_ITERATION = "shortestPathVertexProgram.foundInIteration";
    public static final String MIDDLE = "shortestPathVertexProgram.middle";
    private static final int ID = 0;
    private static final int DIRECTION = 1;
    private static final String DIVIDER = "\t";
    private static final String PREDECESSOR = "shortestPathVertexProgram.fromVertex";
    private static final String VISITED_IN_ITERATION = "shortestPathVertexProgram.visitedInIteration";
    private static final String VOTE_TO_HALT_SOURCE = "shortestPathVertexProgram.voteToHalt.source";
    private static final String VOTE_TO_HALT_DESTINATION = "shortestPathVertexProgram.voteToHalt.destination";
    private static final String FOUND_PATH = "shortestPathVertexProgram.foundDestination";
    private static final String PREDECESSOR_FROM_SOURCE = "shortestPathVertexProgram.fromSource";
    private static final String PREDECESSOR_FROM_DESTINATION = "shortestPathVertexProgram.fromDestination";
    private static final String PREDECESSORS = "shortestPathVertexProgram.predecessors";
    private static final String SOURCE = "shortestPathVertexProgram.startId";
    private static final String DESTINATION = "shortestPathVertexProgram.endId";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new MemoryComputeKey[]{MemoryComputeKey.of((String)"shortestPathVertexProgram.voteToHalt.source", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.voteToHalt.destination", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.foundDestination", (BinaryOperator)Operator.or, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.fromSource", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.fromDestination", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.predecessors", (BinaryOperator)Operator.assign, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.middle", (BinaryOperator)Operator.assign, (boolean)false, (boolean)false)});

    public ShortestPathVertexProgram() {
    }

    public ShortestPathVertexProgram(ConceptId sourceId, ConceptId destinationId) {
        this.persistentProperties.put(SOURCE, sourceId.getValue());
        this.persistentProperties.put(DESTINATION, destinationId.getValue());
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Sets.newHashSet((Object[])new VertexComputeKey[]{VertexComputeKey.of((String)PREDECESSOR, (boolean)true), VertexComputeKey.of((String)VISITED_IN_ITERATION, (boolean)true), VertexComputeKey.of((String)FOUND_IN_ITERATION, (boolean)false)});
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return (Boolean)memory.get(FOUND_PATH) != false ? Collections.emptySet() : messageScopeSetInAndOut;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ShortestPathVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT_SOURCE, (Object)true);
        memory.set(VOTE_TO_HALT_DESTINATION, (Object)true);
        memory.set(FOUND_PATH, (Object)false);
        memory.set(PREDECESSOR_FROM_SOURCE, (Object)"");
        memory.set(PREDECESSOR_FROM_DESTINATION, (Object)"");
        memory.set(PREDECESSORS, (Object)"");
        memory.set(MIDDLE, (Object)"");
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Tuple> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                String id = (String)vertex.value(Schema.VertexProperty.ID.name());
                if (this.persistentProperties.get(SOURCE).equals(id)) {
                    LOGGER.debug("Found source vertex");
                    vertex.property(PREDECESSOR, (Object)"");
                    vertex.property(VISITED_IN_ITERATION, (Object)1);
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)1));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)1));
                    break;
                }
                if (!this.persistentProperties.get(DESTINATION).equals(id)) break;
                LOGGER.debug("Found destination vertex");
                vertex.property(PREDECESSOR, (Object)"");
                vertex.property(VISITED_IN_ITERATION, (Object)-1);
                messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)-1));
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)-1));
                break;
            }
            default: {
                if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
                    String id = (String)vertex.value(Schema.VertexProperty.ID.name());
                    if (memory.get(PREDECESSOR_FROM_SOURCE).equals(id)) {
                        LOGGER.debug("Traversing back to vertex " + id);
                        memory.add(PREDECESSOR_FROM_SOURCE, vertex.value(PREDECESSOR));
                        vertex.property(FOUND_IN_ITERATION, (Object)(-1 * memory.getIteration()));
                        break;
                    }
                    if (!memory.get(PREDECESSOR_FROM_DESTINATION).equals(id)) break;
                    LOGGER.debug("Traversing back to vertex " + id);
                    memory.add(PREDECESSOR_FROM_DESTINATION, vertex.value(PREDECESSOR));
                    vertex.property(FOUND_IN_ITERATION, (Object)memory.getIteration());
                    break;
                }
                if (!messenger.receiveMessages().hasNext()) break;
                this.updateInstance(vertex, messenger, memory);
            }
        }
    }

    private void updateInstance(Vertex vertex, Messenger<Tuple> messenger, Memory memory) {
        block5: {
            int messageDirection;
            block6: {
                block4: {
                    if (vertex.property(PREDECESSOR).isPresent()) break block4;
                    String id = (String)vertex.value(Schema.VertexProperty.ID.name());
                    LOGGER.debug("Considering instance " + id);
                    Iterator iterator = messenger.receiveMessages();
                    boolean hasMessageSource = false;
                    boolean hasMessageDestination = false;
                    String predecessorFromSource = null;
                    String predecessorFromDestination = null;
                    while (iterator.hasNext()) {
                        Tuple message = (Tuple)iterator.next();
                        int messageDirection2 = (Integer)message.getValue(1);
                        if (messageDirection2 > 0) {
                            if (hasMessageSource) continue;
                            LOGGER.debug("Received a message from source vertex");
                            hasMessageSource = true;
                            predecessorFromSource = (String)message.getValue(0);
                            vertex.property(PREDECESSOR, (Object)predecessorFromSource);
                            vertex.property(VISITED_IN_ITERATION, (Object)(memory.getIteration() + 1));
                            memory.add(VOTE_TO_HALT_SOURCE, (Object)false);
                            if (!hasMessageDestination) continue;
                            LOGGER.debug("Found path");
                            memory.add(FOUND_PATH, (Object)true);
                            memory.add(PREDECESSORS, (Object)(predecessorFromSource + DIVIDER + predecessorFromDestination + DIVIDER + id));
                            return;
                        }
                        if (hasMessageDestination) continue;
                        LOGGER.debug("Received a message from destination vertex");
                        hasMessageDestination = true;
                        predecessorFromDestination = (String)message.getValue(0);
                        vertex.property(PREDECESSOR, (Object)predecessorFromDestination);
                        vertex.property(VISITED_IN_ITERATION, (Object)(-1 * memory.getIteration() - 1));
                        memory.add(VOTE_TO_HALT_DESTINATION, (Object)false);
                        if (!hasMessageSource) continue;
                        LOGGER.debug("Found path");
                        memory.add(FOUND_PATH, (Object)true);
                        memory.add(PREDECESSORS, (Object)(predecessorFromSource + DIVIDER + predecessorFromDestination + DIVIDER + id));
                        return;
                    }
                    int message = hasMessageSource ? 1 : -1;
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)message));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)message));
                    break block5;
                }
                messageDirection = memory.getIteration() / (Integer)vertex.value(VISITED_IN_ITERATION);
                if (messageDirection != 1) break block6;
                Iterator iterator = messenger.receiveMessages();
                while (iterator.hasNext()) {
                    Tuple message = (Tuple)iterator.next();
                    if ((Integer)message.getValue(1) != -1) continue;
                    LOGGER.debug("Found path");
                    memory.add(FOUND_PATH, (Object)true);
                    memory.add(PREDECESSORS, (Object)(vertex.value(Schema.VertexProperty.ID.name()) + DIVIDER + message.getValue(0)));
                    return;
                }
                break block5;
            }
            if (messageDirection != -1) break block5;
            Iterator iterator = messenger.receiveMessages();
            while (iterator.hasNext()) {
                Tuple message = (Tuple)iterator.next();
                if ((Integer)message.getValue(1) != 1) continue;
                LOGGER.debug("Found path");
                memory.add(FOUND_PATH, (Object)true);
                memory.add(PREDECESSORS, (Object)(message.getValue(0) + DIVIDER + vertex.value(Schema.VertexProperty.ID.name())));
                return;
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() == 0) {
            return false;
        }
        if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
            if (!memory.get(PREDECESSORS).equals("")) {
                String[] predecessors = ((String)memory.get(PREDECESSORS)).split(DIVIDER);
                memory.set(PREDECESSORS, (Object)"");
                memory.set(PREDECESSOR_FROM_SOURCE, (Object)predecessors[0]);
                memory.set(PREDECESSOR_FROM_DESTINATION, (Object)predecessors[1]);
                if (predecessors.length > 2) {
                    memory.set(MIDDLE, (Object)predecessors[2]);
                }
                return predecessors[0].equals(this.persistentProperties.get(SOURCE));
            }
            return memory.get(PREDECESSOR_FROM_SOURCE).equals(this.persistentProperties.get(SOURCE));
        }
        if (((Boolean)memory.get(VOTE_TO_HALT_SOURCE)).booleanValue() || ((Boolean)memory.get(VOTE_TO_HALT_DESTINATION)).booleanValue()) {
            LOGGER.debug("There is no path between the given instances");
            throw new NoResultException();
        }
        if (memory.getIteration() == 50) {
            LOGGER.debug("Reached Max Iteration: 50 !!!!!!!!");
            throw GraqlQueryException.maxIterationsReached(this.getClass());
        }
        memory.set(VOTE_TO_HALT_SOURCE, (Object)true);
        memory.set(VOTE_TO_HALT_DESTINATION, (Object)true);
        return false;
    }
}

