/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.StatisticsMapReduce;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class StdMapReduce
extends StatisticsMapReduce<Map<String, Double>> {
    public static final String COUNT = "C";
    public static final String SUM = "S";
    public static final String SQUARE_SUM = "SM";

    public StdMapReduce() {
    }

    public StdMapReduce(Set<LabelId> selectedLabelIds, AttributeType.DataType resourceDataType, String degreePropertyKey) {
        super(selectedLabelIds, resourceDataType, degreePropertyKey);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Map<String, Double>> emitter) {
        if (this.resourceIsValid(vertex)) {
            HashMap<String, Double> tuple = new HashMap<String, Double>(3);
            Double degree = ((Long)vertex.value(this.degreePropertyKey)).doubleValue();
            double value = this.resourceValue(vertex).doubleValue();
            tuple.put(SUM, value * degree);
            tuple.put(SQUARE_SUM, value * value * degree);
            tuple.put(COUNT, degree);
            emitter.emit((Object)MapReduce.NullObject.instance(), tuple);
            return;
        }
        HashMap<String, Double> emptyTuple = new HashMap<String, Double>(3);
        emptyTuple.put(SUM, 0.0);
        emptyTuple.put(SQUARE_SUM, 0.0);
        emptyTuple.put(COUNT, 0.0);
        emitter.emit((Object)MapReduce.NullObject.instance(), emptyTuple);
    }

    @Override
    Map<String, Double> reduceValues(Iterator<Map<String, Double>> values) {
        HashMap<String, Double> emptyTuple = new HashMap<String, Double>(3);
        emptyTuple.put(SUM, 0.0);
        emptyTuple.put(SQUARE_SUM, 0.0);
        emptyTuple.put(COUNT, 0.0);
        return (Map)IteratorUtils.reduce(values, emptyTuple, (a, b) -> {
            a.put(COUNT, (Double)a.get(COUNT) + (Double)b.get(COUNT));
            a.put(SUM, (Double)a.get(SUM) + (Double)b.get(SUM));
            a.put(SQUARE_SUM, (Double)a.get(SQUARE_SUM) + (Double)b.get(SQUARE_SUM));
            return a;
        });
    }
}

