/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.StatisticsMapReduce;
import ai.grakn.util.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SumMapReduce
extends StatisticsMapReduce<Number> {
    public SumMapReduce() {
    }

    public SumMapReduce(Set<LabelId> selectedLabelIds, AttributeType.DataType resourceDataType, String degreePropertyKey) {
        super(selectedLabelIds, resourceDataType, degreePropertyKey);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Number> emitter) {
        if (this.usingLong()) {
            if (this.resourceIsValid(vertex)) {
                emitter.emit((Object)MapReduce.NullObject.instance(), (Object)((Long)vertex.value(Schema.VertexProperty.VALUE_LONG.name()) * (Long)vertex.value(this.degreePropertyKey)));
                return;
            }
            emitter.emit((Object)MapReduce.NullObject.instance(), (Object)0L);
        } else {
            if (this.resourceIsValid(vertex)) {
                emitter.emit((Object)MapReduce.NullObject.instance(), (Object)((Double)vertex.value(Schema.VertexProperty.VALUE_DOUBLE.name()) * (double)((Long)vertex.value(this.degreePropertyKey)).longValue()));
                return;
            }
            emitter.emit((Object)MapReduce.NullObject.instance(), (Object)0.0);
        }
    }

    @Override
    Number reduceValues(Iterator<Number> values) {
        if (this.usingLong()) {
            return (Number)IteratorUtils.reduce(values, (Object)0L, (a, b) -> a.longValue() + b.longValue());
        }
        return (Number)IteratorUtils.reduce(values, (Object)0.0, (a, b) -> a.doubleValue() + b.doubleValue());
    }
}

