/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknTx;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.ConjunctionQuery;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.spanningtree.Arborescence;
import ai.grakn.graql.internal.gremlin.spanningtree.ChuLiuEdmonds;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.Node;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.NodeId;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.SparseWeightedGraph;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyTraversalPlan {
    protected static final Logger LOG = LoggerFactory.getLogger(GreedyTraversalPlan.class);

    public static GraqlTraversal createTraversal(PatternAdmin pattern, GraknTx graph) {
        Set patterns = pattern.getDisjunctiveNormalForm().getPatterns();
        Set fragments = (Set)patterns.stream().map(conjunction -> new ConjunctionQuery((Conjunction<VarPatternAdmin>)conjunction, graph)).map(GreedyTraversalPlan::planForConjunction).collect(CommonUtil.toImmutableSet());
        return GraqlTraversal.create(fragments);
    }

    private static List<Fragment> planForConjunction(ConjunctionQuery query) {
        ArrayList<Fragment> plan = new ArrayList<Fragment>();
        HashMap<NodeId, Node> allNodes = new HashMap<NodeId, Node>();
        Collection<Set<Fragment>> connectedFragmentSets = GreedyTraversalPlan.getConnectedFragmentSets(query, allNodes);
        connectedFragmentSets.forEach(fragmentSet -> {
            HashSet<Node> connectedNodes = new HashSet<Node>();
            HashMap<Node, Map<Node, Fragment>> edges = new HashMap<Node, Map<Node, Fragment>>();
            HashSet<Node> nodesWithFixedCost = new HashSet<Node>();
            HashSet weightedGraph = new HashSet();
            fragmentSet.stream().filter(GreedyTraversalPlan.filterNodeFragment(plan, allNodes, connectedNodes, nodesWithFixedCost)).flatMap(fragment -> fragment.directedEdges(allNodes, edges).stream()).forEach(weightedDirectedEdge -> {
                weightedGraph.add(weightedDirectedEdge);
                connectedNodes.add((Node)((DirectedEdge)weightedDirectedEdge.val).destination);
                connectedNodes.add((Node)((DirectedEdge)weightedDirectedEdge.val).source);
            });
            if (!weightedGraph.isEmpty()) {
                SparseWeightedGraph sparseWeightedGraph = SparseWeightedGraph.from(weightedGraph);
                HashSet<Node> startingNodes = nodesWithFixedCost.isEmpty() ? (Collection)sparseWeightedGraph.getNodes().stream().filter(Node::isValidStartingPoint).collect(Collectors.toSet()) : nodesWithFixedCost;
                Arborescence<Node> arborescence = startingNodes.stream().map(node -> ChuLiuEdmonds.getMaxArborescence(sparseWeightedGraph, node)).max(Comparator.comparingDouble(tree -> tree.weight)).map(arborescenceInside -> (Arborescence)arborescenceInside.val).orElse(Arborescence.empty());
                GreedyTraversalPlan.greedyTraversal(plan, arborescence, allNodes, edges);
            }
            GreedyTraversalPlan.addUnvisitedNodeFragments(plan, allNodes, connectedNodes);
        });
        GreedyTraversalPlan.addUnvisitedNodeFragments(plan, allNodes, allNodes.values());
        LOG.trace("Greedy Plan = " + plan);
        return plan;
    }

    private static void addUnvisitedNodeFragments(List<Fragment> plan, Map<NodeId, Node> allNodes, Collection<Node> connectedNodes) {
        Set<Node> nodeWithFragment = connectedNodes.stream().filter(node -> !node.getFragmentsWithoutDependency().isEmpty() || !node.getFragmentsWithDependencyVisited().isEmpty()).collect(Collectors.toSet());
        while (!nodeWithFragment.isEmpty()) {
            nodeWithFragment.forEach(node -> GreedyTraversalPlan.addNodeFragmentToPlan(node, plan, allNodes, false));
            nodeWithFragment = connectedNodes.stream().filter(node -> !node.getFragmentsWithoutDependency().isEmpty() || !node.getFragmentsWithDependencyVisited().isEmpty()).collect(Collectors.toSet());
        }
    }

    private static Predicate<Fragment> filterNodeFragment(List<Fragment> plan, Map<NodeId, Node> allNodes, Set<Node> connectedNodes, Set<Node> nodesWithFixedCost) {
        return fragment -> {
            if (fragment.end() == null) {
                Node start = Node.addIfAbsent(NodeId.NodeType.VAR, fragment.start(), allNodes);
                connectedNodes.add(start);
                if (fragment.hasFixedFragmentCost()) {
                    plan.add((Fragment)fragment);
                    nodesWithFixedCost.add(start);
                    start.setFixedFragmentCost(fragment.fragmentCost());
                } else if (fragment.dependencies().isEmpty()) {
                    start.getFragmentsWithoutDependency().add((Fragment)fragment);
                }
                return false;
            }
            return true;
        };
    }

    private static Collection<Set<Fragment>> getConnectedFragmentSets(ConjunctionQuery query, Map<NodeId, Node> allNodes) {
        HashMap varSetMap = new HashMap();
        HashMap fragmentSetMap = new HashMap();
        int[] index = new int[]{0};
        query.getEquivalentFragmentSets().stream().flatMap(EquivalentFragmentSet::stream).forEach(fragment -> {
            if (!fragment.dependencies().isEmpty()) {
                Node start = Node.addIfAbsent(NodeId.NodeType.VAR, fragment.start(), allNodes);
                Node other = Node.addIfAbsent(NodeId.NodeType.VAR, fragment.dependencies().iterator().next(), allNodes);
                start.getFragmentsWithDependency().add((Fragment)fragment);
                other.getDependants().add((Fragment)fragment);
                if (fragment.varProperty() instanceof ValueProperty) {
                    other.getFragmentsWithDependency().add((Fragment)fragment);
                    start.getDependants().add((Fragment)fragment);
                }
            }
            HashSet fragmentVarNameSet = Sets.newHashSet(fragment.vars());
            ArrayList setsWithVarInCommon = new ArrayList();
            varSetMap.forEach((setIndex, varNameSet) -> {
                if (!Collections.disjoint(varNameSet, fragmentVarNameSet)) {
                    setsWithVarInCommon.add(setIndex);
                }
            });
            if (setsWithVarInCommon.isEmpty()) {
                index[0] = index[0] + 1;
                varSetMap.put(index[0], fragmentVarNameSet);
                fragmentSetMap.put(index[0], Sets.newHashSet((Object[])new Fragment[]{fragment}));
            } else {
                Iterator iterator = setsWithVarInCommon.iterator();
                Integer firstSet = (Integer)iterator.next();
                ((Set)varSetMap.get(firstSet)).addAll(fragmentVarNameSet);
                ((Set)fragmentSetMap.get(firstSet)).add(fragment);
                while (iterator.hasNext()) {
                    Integer nextSet = (Integer)iterator.next();
                    ((Set)varSetMap.get(firstSet)).addAll((Collection)varSetMap.remove(nextSet));
                    ((Set)fragmentSetMap.get(firstSet)).addAll((Collection)fragmentSetMap.remove(nextSet));
                }
            }
        });
        return fragmentSetMap.values();
    }

    private static void greedyTraversal(List<Fragment> plan, Arborescence<Node> arborescence, Map<NodeId, Node> nodes, Map<Node, Map<Node, Fragment>> edgeFragmentChildToParent) {
        HashMap edgesParentToChild = new HashMap();
        arborescence.getParents().forEach((child, parent) -> {
            if (!edgesParentToChild.containsKey(parent)) {
                edgesParentToChild.put(parent, new HashSet());
            }
            ((Set)edgesParentToChild.get(parent)).add(child);
        });
        Node root = arborescence.getRoot();
        HashSet reachableNodes = Sets.newHashSet((Object[])new Node[]{root});
        while (!reachableNodes.isEmpty()) {
            Node nodeWithMinCost = reachableNodes.stream().min(Comparator.comparingDouble(node -> GreedyTraversalPlan.branchWeight(node, arborescence, edgesParentToChild, edgeFragmentChildToParent))).get();
            GreedyTraversalPlan.getEdgeFragment(nodeWithMinCost, arborescence, edgeFragmentChildToParent).ifPresent(plan::add);
            GreedyTraversalPlan.addNodeFragmentToPlan(nodeWithMinCost, plan, nodes, true);
            reachableNodes.remove(nodeWithMinCost);
            if (!edgesParentToChild.containsKey(nodeWithMinCost)) continue;
            reachableNodes.addAll((Collection)edgesParentToChild.get(nodeWithMinCost));
        }
    }

    private static double branchWeight(Node node, Arborescence<Node> arborescence, Map<Node, Set<Node>> edgesParentToChild, Map<Node, Map<Node, Fragment>> edgeFragmentChildToParent) {
        double[] weight = new double[]{GreedyTraversalPlan.getEdgeFragmentCost(node, arborescence, edgeFragmentChildToParent)};
        weight[0] = weight[0] + GreedyTraversalPlan.nodeFragmentWeight(node);
        if (edgesParentToChild.containsKey(node)) {
            edgesParentToChild.get(node).forEach(child -> {
                weight[0] = weight[0] + GreedyTraversalPlan.branchWeight(child, arborescence, edgesParentToChild, edgeFragmentChildToParent);
            });
        }
        return weight[0];
    }

    private static double nodeFragmentWeight(Node node) {
        double costFragmentsWithoutDependency = node.getFragmentsWithoutDependency().stream().mapToDouble(Fragment::fragmentCost).sum();
        double costFragmentsWithDependencyVisited = node.getFragmentsWithDependencyVisited().stream().mapToDouble(Fragment::fragmentCost).sum();
        return costFragmentsWithoutDependency + costFragmentsWithDependencyVisited + node.getFixedFragmentCost();
    }

    private static void addNodeFragmentToPlan(Node node, List<Fragment> plan, Map<NodeId, Node> nodes, boolean visited) {
        if (!visited) {
            node.getFragmentsWithoutDependency().stream().min(Comparator.comparingDouble(Fragment::fragmentCost)).ifPresent(firstNodeFragment -> {
                plan.add((Fragment)firstNodeFragment);
                node.getFragmentsWithoutDependency().remove(firstNodeFragment);
            });
        }
        node.getFragmentsWithoutDependency().addAll(node.getFragmentsWithDependencyVisited());
        plan.addAll(node.getFragmentsWithoutDependency().stream().sorted(Comparator.comparingDouble(Fragment::fragmentCost)).collect(Collectors.toList()));
        node.getFragmentsWithoutDependency().clear();
        node.getFragmentsWithDependencyVisited().clear();
        if (!node.getFragmentsWithDependency().isEmpty()) {
            node.getDependants().forEach(fragment -> {
                Node otherNode = (Node)nodes.get(new NodeId(NodeId.NodeType.VAR, fragment.start()));
                if (node.equals(otherNode)) {
                    otherNode = (Node)nodes.get(new NodeId(NodeId.NodeType.VAR, fragment.dependencies().iterator().next()));
                }
                otherNode.getFragmentsWithDependencyVisited().add((Fragment)fragment);
                otherNode.getFragmentsWithDependency().remove(fragment);
            });
            node.getFragmentsWithDependency().clear();
        }
        node.getDependants().clear();
    }

    private static double getEdgeFragmentCost(Node node, Arborescence<Node> arborescence, Map<Node, Map<Node, Fragment>> edgeToFragment) {
        Optional<Fragment> fragment = GreedyTraversalPlan.getEdgeFragment(node, arborescence, edgeToFragment);
        return fragment.map(Fragment::fragmentCost).orElse(0.0);
    }

    private static Optional<Fragment> getEdgeFragment(Node node, Arborescence<Node> arborescence, Map<Node, Map<Node, Fragment>> edgeToFragment) {
        if (edgeToFragment.containsKey(node) && edgeToFragment.get(node).containsKey(arborescence.getParents().get((Object)node))) {
            return Optional.of(edgeToFragment.get(node).get(arborescence.getParents().get((Object)node)));
        }
        return Optional.empty();
    }
}

