/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.Node;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.NodeId;
import ai.grakn.graql.internal.gremlin.spanningtree.util.Weighted;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class Fragment {
    private static final long NUM_INSTANCES_PER_TYPE = 100L;
    private static final long NUM_SUBTYPES_PER_TYPE = 3L;
    private static final long NUM_RELATIONS_PER_INSTANCE = 30L;
    private static final long NUM_TYPES_PER_ROLE = 3L;
    private static final long NUM_ROLES_PER_TYPE = 3L;
    private static final long NUM_ROLE_PLAYERS_PER_RELATION = 2L;
    private static final long NUM_ROLE_PLAYERS_PER_ROLE = 1L;
    private static final long NUM_RESOURCES_PER_VALUE = 2L;
    static final double COST_INSTANCES_PER_TYPE = Math.log1p(100.0);
    static final double COST_SUBTYPES_PER_TYPE = Math.log1p(3.0);
    static final double COST_RELATIONS_PER_INSTANCE = Math.log1p(30.0);
    static final double COST_TYPES_PER_ROLE = Math.log1p(3.0);
    static final double COST_ROLES_PER_TYPE = Math.log1p(3.0);
    static final double COST_ROLE_PLAYERS_PER_RELATION = Math.log1p(2.0);
    static final double COST_ROLE_PLAYERS_PER_ROLE = Math.log1p(1.0);
    static final double COST_SAME_AS_PREVIOUS = Math.log1p(1.0);
    static final double COST_NODE_INDEX = -Math.log(100.0);
    static final double COST_NODE_INDEX_VALUE = -Math.log(50.0);
    static final double COST_NODE_NEQ = -Math.log(2.0);
    static final double COST_NODE_DATA_TYPE = -Math.log((double)AttributeType.DataType.SUPPORTED_TYPES.size() / 2.0);
    static final double COST_NODE_UNSPECIFIC_PREDICATE = -Math.log(2.0);
    static final double COST_NODE_REGEX = -Math.log(2.0);
    static final double COST_NODE_NOT_INTERNAL = -Math.log(1.1);
    static final double COST_NODE_IS_ABSTRACT = -Math.log(1.1);
    @Nullable
    private ImmutableSet<Var> vars = null;

    @Nullable
    public abstract VarProperty varProperty();

    public abstract Var start();

    @Nullable
    public Var end() {
        return null;
    }

    ImmutableSet<Var> otherVars() {
        return ImmutableSet.of();
    }

    public Set<Var> dependencies() {
        return ImmutableSet.of();
    }

    public Set<Weighted<DirectedEdge<Node>>> directedEdges(Map<NodeId, Node> nodes, Map<Node, Map<Node, Fragment>> edges) {
        return Collections.emptySet();
    }

    public final GraphTraversal<Vertex, ? extends Element> applyTraversal(GraphTraversal<Vertex, ? extends Element> traversal, GraknTx graph, Collection<Var> vars, @Nullable Var currentVar) {
        if (currentVar != null) {
            if (!currentVar.equals((Object)this.start())) {
                if (vars.contains(this.start())) {
                    traversal.select(this.start().name());
                } else {
                    traversal.V(new Object[0]).as(this.start().name(), new String[0]);
                }
            }
        } else {
            traversal.as(this.start().name(), new String[0]);
        }
        vars.add(this.start());
        traversal = this.applyTraversalInner(traversal, graph, vars);
        Var end = this.end();
        if (end != null) {
            Fragment.assignVar(traversal, end, vars);
        }
        vars.addAll(this.vars());
        return traversal;
    }

    static <T, U> GraphTraversal<T, U> assignVar(GraphTraversal<T, U> traversal, Var var, Collection<Var> vars) {
        if (!vars.contains(var)) {
            return traversal.as(var.name(), new String[0]);
        }
        return traversal.where(P.eq((Object)var.name()));
    }

    abstract GraphTraversal<Vertex, ? extends Element> applyTraversalInner(GraphTraversal<Vertex, ? extends Element> var1, GraknTx var2, Collection<Var> var3);

    public abstract String name();

    public boolean isStartingFragment() {
        return false;
    }

    public abstract double fragmentCost();

    public boolean hasFixedFragmentCost() {
        return false;
    }

    public boolean canOperateOnEdges() {
        return false;
    }

    public final Set<Var> vars() {
        if (this.vars == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder().add((Object)this.start());
            Var end = this.end();
            if (end != null) {
                builder.add((Object)end);
            }
            builder.addAll(this.otherVars());
            this.vars = builder.build();
        }
        return this.vars;
    }

    public final String toString() {
        return this.start() + this.name() + Optional.ofNullable(this.end()).map(Object::toString).orElse("");
    }

    final Set<Weighted<DirectedEdge<Node>>> directedEdges(NodeId.NodeType nodeType, Map<NodeId, Node> nodes, Map<Node, Map<Node, Fragment>> edgeToFragment) {
        Node start = Node.addIfAbsent(NodeId.NodeType.VAR, this.start(), nodes);
        Node end = Node.addIfAbsent(NodeId.NodeType.VAR, this.end(), nodes);
        Node middle = Node.addIfAbsent(nodeType, Sets.newHashSet((Object[])new Var[]{this.start(), this.end()}), nodes);
        middle.setInvalidStartingPoint();
        this.addEdgeToFragmentMapping(middle, start, edgeToFragment);
        return Sets.newHashSet((Object[])new Weighted[]{Weighted.weighted(DirectedEdge.from(start).to(middle), -this.fragmentCost()), Weighted.weighted(DirectedEdge.from(middle).to(end), 0.0)});
    }

    final Set<Weighted<DirectedEdge<Node>>> directedEdges(Var edge, Map<NodeId, Node> nodes, Map<Node, Map<Node, Fragment>> edgeToFragment) {
        Node start = Node.addIfAbsent(NodeId.NodeType.VAR, this.start(), nodes);
        Node end = Node.addIfAbsent(NodeId.NodeType.VAR, this.end(), nodes);
        Node middle = Node.addIfAbsent(NodeId.NodeType.VAR, edge, nodes);
        middle.setInvalidStartingPoint();
        this.addEdgeToFragmentMapping(middle, start, edgeToFragment);
        return Sets.newHashSet((Object[])new Weighted[]{Weighted.weighted(DirectedEdge.from(start).to(middle), -this.fragmentCost()), Weighted.weighted(DirectedEdge.from(middle).to(end), 0.0)});
    }

    private void addEdgeToFragmentMapping(Node child, Node parent, Map<Node, Map<Node, Fragment>> edgeToFragment) {
        if (!edgeToFragment.containsKey(child)) {
            edgeToFragment.put(child, new HashMap());
        }
        edgeToFragment.get(child).put(parent, this);
    }
}

