/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

abstract class LabelFragment
extends Fragment {
    LabelFragment() {
    }

    abstract ImmutableSet<Label> labels();

    @Override
    public GraphTraversal<Vertex, ? extends Element> applyTraversalInner(GraphTraversal<Vertex, ? extends Element> traversal, GraknTx graph, Collection<Var> vars) {
        Set labelIds = this.labels().stream().map(label -> graph.admin().convertToId(label).getValue()).collect(Collectors.toSet());
        if (labelIds.size() == 1) {
            int labelId = (Integer)Iterables.getOnlyElement(labelIds);
            return traversal.has(Schema.VertexProperty.LABEL_ID.name(), (Object)labelId);
        }
        return traversal.has(Schema.VertexProperty.LABEL_ID.name(), P.within(labelIds));
    }

    @Override
    public String name() {
        return "[label:" + this.labels().stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public double fragmentCost() {
        return COST_NODE_INDEX;
    }

    @Override
    public boolean hasFixedFragmentCost() {
        return true;
    }
}

