/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.gremlin.sets.FragmentSetOptimisation;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

abstract class LabelFragmentSet
extends EquivalentFragmentSet {
    static final FragmentSetOptimisation REDUNDANT_LABEL_ELIMINATION_OPTIMISATION = (fragmentSets, graph) -> {
        if (fragmentSets.size() <= 1) {
            return false;
        }
        Iterable labelFragments = EquivalentFragmentSets.fragmentSetOfType(LabelFragmentSet.class, fragmentSets)::iterator;
        for (LabelFragmentSet labelSet : labelFragments) {
            boolean varReferredToInOtherFragment;
            boolean existsInGraph;
            boolean hasUserDefinedVar = labelSet.var().isUserDefinedName();
            if (hasUserDefinedVar || !(existsInGraph = labelSet.labels().stream().anyMatch(label -> graph.getSchemaConcept(label) != null)) || (varReferredToInOtherFragment = fragmentSets.stream().filter(set -> !set.equals(labelSet)).flatMap(set -> set.fragments().stream()).map(Fragment::vars).anyMatch(vars -> vars.contains(labelSet.var())))) continue;
            fragmentSets.remove(labelSet);
            return true;
        }
        return false;
    };

    LabelFragmentSet() {
    }

    @Override
    public final Set<Fragment> fragments() {
        return ImmutableSet.of((Object)Fragments.label(this.varProperty(), this.var(), this.labels()));
    }

    abstract Var var();

    abstract ImmutableSet<Label> labels();

    @Nullable
    LabelFragmentSet tryExpandSubs(Var typeVar, GraknTx tx) {
        if (this.labels().size() != 1) {
            return null;
        }
        Label oldLabel = (Label)Iterables.getOnlyElement(this.labels());
        SchemaConcept concept = tx.getSchemaConcept(oldLabel);
        if (concept == null) {
            return null;
        }
        Set newLabels = concept.subs().map(SchemaConcept::getLabel).collect(Collectors.toSet());
        return new AutoValue_LabelFragmentSet(this.varProperty(), typeVar, (ImmutableSet<Label>)ImmutableSet.copyOf(newLabels));
    }
}

