/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree;

import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ExclusiveEdge<V>
implements Comparable<ExclusiveEdge<V>> {
    public final DirectedEdge<V> edge;
    public final List<DirectedEdge<V>> excluded;
    public final double weight;

    private ExclusiveEdge(DirectedEdge<V> edge, List<DirectedEdge<V>> excluded, double weight) {
        this.edge = edge;
        this.excluded = excluded;
        this.weight = weight;
    }

    public static <T> ExclusiveEdge<T> of(DirectedEdge<T> edge, List<DirectedEdge<T>> excluded, double weight) {
        return new ExclusiveEdge<T>(edge, excluded, weight);
    }

    public static <T> ExclusiveEdge<T> of(DirectedEdge<T> edge, double weight) {
        return ExclusiveEdge.of(edge, ImmutableList.of(), weight);
    }

    @Override
    public int compareTo(ExclusiveEdge<V> exclusiveEdge) {
        return Double.compare(this.weight, exclusiveEdge.weight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExclusiveEdge that = (ExclusiveEdge)o;
        return this.edge != null && this.edge.equals(that.edge) && this.excluded != null && this.excluded.equals(that.excluded) && Double.compare(this.weight, that.weight) == 0;
    }

    public int hashCode() {
        int result = this.edge != null ? this.edge.hashCode() : 0;
        result = result * 31 + (this.excluded != null ? this.excluded.hashCode() : 0);
        result = result * 31 + Double.valueOf(this.weight).hashCode();
        return result;
    }
}

