/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.datastructure;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;

public class FibonacciHeap<V, P>
implements Iterable<Entry> {
    public static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private static final int MAX_DEGREE = 45;
    private Optional<Entry> oMinEntry = Optional.empty();
    private int size = 0;
    private final Comparator<? super P> comparator;

    private FibonacciHeap(Comparator<? super P> comparator) {
        this.comparator = Ordering.from(comparator).nullsFirst();
    }

    public static <T, C> FibonacciHeap<T, C> create(Comparator<? super C> comparator) {
        return new FibonacciHeap(comparator);
    }

    public static <T, C extends Comparable> FibonacciHeap<T, C> create() {
        return FibonacciHeap.create(Ordering.natural());
    }

    public Comparator<? super P> comparator() {
        return this.comparator;
    }

    public void clear() {
        this.oMinEntry = Optional.empty();
        this.size = 0;
    }

    public void decreasePriority(Entry entry, P newPriority) {
        Preconditions.checkArgument((this.comparator.compare(newPriority, entry.priority) <= 0 ? 1 : 0) != 0, (Object)"Cannot increase priority");
        entry.priority = newPriority;
        assert (this.oMinEntry.isPresent());
        Entry minEntry = this.oMinEntry.get();
        if (entry.oParent.isPresent() && this.comparator.compare(newPriority, ((Entry)entry.oParent.get()).priority) < 0) {
            this.cutAndMakeRoot(entry);
        }
        if (this.comparator.compare(newPriority, minEntry.priority) < 0) {
            this.oMinEntry = Optional.of(entry);
        }
    }

    public void remove(Entry entry) {
        entry.priority = null;
        this.cutAndMakeRoot(entry);
        this.oMinEntry = Optional.of(entry);
        this.pollOption();
    }

    public boolean isEmpty() {
        return !this.oMinEntry.isPresent();
    }

    public Optional<Entry> add(V value, P priority) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull(priority);
        if (this.size >= Integer.MAX_VALUE) {
            return Optional.empty();
        }
        Entry result = new Entry(value, priority);
        this.oMinEntry = this.mergeLists(Optional.of(result), this.oMinEntry);
        ++this.size;
        return Optional.of(result);
    }

    public Optional<Entry> peekOption() {
        return this.oMinEntry;
    }

    public Optional<V> pollOption() {
        if (!this.oMinEntry.isPresent()) {
            return Optional.empty();
        }
        Entry minEntry = this.oMinEntry.get();
        if (minEntry.oFirstChild.isPresent()) {
            for (Entry childOfMin : this.getCycle((Entry)minEntry.oFirstChild.get())) {
                childOfMin.oParent = Optional.empty();
            }
            this.mergeLists(this.oMinEntry, minEntry.oFirstChild);
        }
        if (this.size == 1) {
            this.oMinEntry = Optional.empty();
        } else {
            Entry next = minEntry.next;
            FibonacciHeap.unlinkFromNeighbors(minEntry);
            this.oMinEntry = Optional.of(this.consolidate(next));
        }
        --this.size;
        return Optional.of(minEntry.value);
    }

    public int size() {
        return this.size;
    }

    public static <U, P> FibonacciHeap<U, P> merge(FibonacciHeap<U, P> a, FibonacciHeap<U, P> b) {
        Preconditions.checkArgument((boolean)a.comparator().equals(b.comparator()), (Object)"Heaps that use different comparators can't be merged.");
        FibonacciHeap result = FibonacciHeap.create(a.comparator);
        result.oMinEntry = super.mergeLists(a.oMinEntry, b.oMinEntry);
        result.size = a.size + b.size;
        return result;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.siblingsAndBelow(this.oMinEntry);
    }

    private Iterator<Entry> siblingsAndBelow(Optional<Entry> oEntry) {
        return oEntry.map(entry1 -> Iterators.concat((Iterator)Iterators.transform(this.getCycle((Entry)entry1).iterator(), entry -> {
            assert (entry != null);
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)entry), this.siblingsAndBelow(((Entry)entry).oFirstChild));
        }))).orElse(Collections.emptyIterator());
    }

    private LinkedList<Entry> getCycle(Entry start) {
        LinkedList results = Lists.newLinkedList();
        Entry current = start;
        do {
            results.add(current);
        } while (!(current = current.next).equals(start));
        return results;
    }

    private Optional<Entry> mergeLists(Optional<Entry> oA, Optional<Entry> oB) {
        if (!oA.isPresent()) {
            return oB;
        }
        if (!oB.isPresent()) {
            return oA;
        }
        Entry a = oA.get();
        Entry b = oB.get();
        Entry aOldNext = a.next;
        a.next = b.next;
        a.next.previous = a;
        b.next = aOldNext;
        b.next.previous = b;
        return this.comparator.compare(a.priority, b.priority) < 0 ? oA : oB;
    }

    private void cutAndMakeRoot(Entry entry) {
        if (!entry.oParent.isPresent()) {
            return;
        }
        Entry parent = (Entry)entry.oParent.get();
        parent.degree--;
        entry.isMarked = false;
        assert (parent.oFirstChild.isPresent());
        if (((Entry)parent.oFirstChild.get()).equals(entry)) {
            if (parent.degree == 0) {
                parent.oFirstChild = Optional.empty();
            } else {
                parent.oFirstChild = Optional.of(entry.next);
            }
        }
        entry.oParent = Optional.empty();
        FibonacciHeap.unlinkFromNeighbors(entry);
        this.mergeLists(Optional.of(entry), this.oMinEntry);
        if (parent.oParent.isPresent()) {
            if (parent.isMarked) {
                this.cutAndMakeRoot(parent);
            } else {
                parent.isMarked = true;
            }
        }
    }

    private Entry setParent(Entry entry, Entry parent) {
        FibonacciHeap.unlinkFromNeighbors(entry);
        entry.oParent = Optional.of(parent);
        parent.oFirstChild = this.mergeLists(Optional.of(entry), parent.oFirstChild);
        parent.degree++;
        entry.isMarked = false;
        return parent;
    }

    private static void unlinkFromNeighbors(Entry entry) {
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        entry.previous = entry;
        entry.next = entry;
    }

    private Entry consolidate(Entry someRoot) {
        Entry minRoot = someRoot;
        Object[] rootsByDegree = new Object[45];
        Iterator iterator = this.getCycle(someRoot).iterator();
        while (iterator.hasNext()) {
            Entry currRoot;
            Entry mergedRoot = currRoot = (Entry)iterator.next();
            int degree = currRoot.degree;
            while (rootsByDegree[degree] != null) {
                Entry oldRoot = (Entry)rootsByDegree[degree];
                mergedRoot = this.comparator.compare(mergedRoot.priority, oldRoot.priority) < 0 ? this.setParent(oldRoot, mergedRoot) : this.setParent(mergedRoot, oldRoot);
                rootsByDegree[degree] = null;
                ++degree;
            }
            rootsByDegree[((Entry)mergedRoot).degree] = mergedRoot;
            if (this.comparator.compare(mergedRoot.priority, minRoot.priority) > 0) continue;
            minRoot = mergedRoot;
        }
        return minRoot;
    }

    class Entry {
        public final V value;
        private P priority;
        private Optional<Entry> oParent = Optional.empty();
        private Optional<Entry> oFirstChild = Optional.empty();
        private Entry previous;
        private Entry next;
        private int degree = 0;
        private boolean isMarked = false;

        private Entry(V value, P priority) {
            this.value = value;
            this.priority = priority;
            this.previous = this.next = this;
        }
    }
}

