/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.datastructure;

import ai.grakn.graql.internal.gremlin.spanningtree.datastructure.FibonacciHeap;
import com.google.common.collect.Iterators;
import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;

public class FibonacciQueue<E>
extends AbstractQueue<E> {
    private final FibonacciHeap<E, E> heap;
    private final Function<FibonacciHeap.Entry, E> getValue = input -> {
        assert (input != null);
        return input.value;
    };

    private FibonacciQueue(FibonacciHeap<E, E> heap) {
        this.heap = heap;
    }

    public static <C> FibonacciQueue<C> create(Comparator<? super C> comparator) {
        return new FibonacciQueue<C>(FibonacciHeap.create(comparator));
    }

    public static <C extends Comparable> FibonacciQueue<C> create() {
        return new FibonacciQueue(FibonacciHeap.create());
    }

    public Comparator<? super E> comparator() {
        return this.heap.comparator();
    }

    @Override
    public E peek() {
        Optional<FibonacciHeap.Entry> first = this.heap.peekOption();
        return first.map(entry -> entry.value).orElse(null);
    }

    @Override
    public boolean offer(E e) {
        return this.heap.add(e, e).isPresent();
    }

    @Override
    public E poll() {
        return this.heap.pollOption().orElse(null);
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.heap.iterator(), this.getValue::apply);
    }
}

