/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;

public class DirectedEdge<V> {
    public final V source;
    public final V destination;

    public DirectedEdge(V source, V destination) {
        this.source = source;
        this.destination = destination;
    }

    public static <T> EdgeBuilder<T> from(T source) {
        return new EdgeBuilder(source);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.destination});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", this.source).add("destination", this.destination).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectedEdge other = (DirectedEdge)o;
        return this.source.equals(other.source) && this.destination.equals(other.destination);
    }

    public static <T> Predicate<DirectedEdge<T>> hasDestination(T node) {
        return input -> {
            assert (input != null);
            return input.destination.equals(node);
        };
    }

    public static <T> Predicate<DirectedEdge<T>> competesWith(Set<DirectedEdge<T>> required) {
        ImmutableMap.Builder requiredSourceByDestinationBuilder = ImmutableMap.builder();
        for (DirectedEdge<T> edge : required) {
            requiredSourceByDestinationBuilder.put(edge.destination, edge.source);
        }
        ImmutableMap requiredSourceByDest = requiredSourceByDestinationBuilder.build();
        return arg_0 -> DirectedEdge.lambda$competesWith$1((Map)requiredSourceByDest, arg_0);
    }

    public static <T> Predicate<DirectedEdge<T>> isAutoCycle() {
        return input -> {
            assert (input != null);
            return input.source.equals(input.destination);
        };
    }

    public static <T> Predicate<DirectedEdge<T>> isIn(Set<DirectedEdge<T>> banned) {
        return input -> banned.contains(input);
    }

    private static /* synthetic */ boolean lambda$competesWith$1(Map requiredSourceByDest, DirectedEdge input) {
        assert (input != null);
        return requiredSourceByDest.containsKey(input.destination) && !input.source.equals(requiredSourceByDest.get(input.destination));
    }

    public static class EdgeBuilder<V> {
        public final V source;

        private EdgeBuilder(V source) {
            this.source = source;
        }

        public DirectedEdge<V> to(V destination) {
            return new DirectedEdge<V>(this.source, destination);
        }
    }
}

