/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.graph;

import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.NodeId;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Node {
    private final NodeId nodeId;
    private boolean isValidStartingPoint = true;
    private double fixedFragmentCost = 0.0;
    private Set<Fragment> fragmentsWithoutDependency = new HashSet<Fragment>();
    private Set<Fragment> fragmentsWithDependency = new HashSet<Fragment>();
    private Set<Fragment> fragmentsWithDependencyVisited = new HashSet<Fragment>();
    private Set<Fragment> dependants = new HashSet<Fragment>();

    private Node(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public static Node addIfAbsent(NodeId.NodeType nodeType, Var var, Map<NodeId, Node> nodes) {
        NodeId nodeId = new NodeId(nodeType, var);
        if (!nodes.containsKey(nodeId)) {
            nodes.put(nodeId, new Node(nodeId));
        }
        return nodes.get(nodeId);
    }

    public static Node addIfAbsent(NodeId.NodeType nodeType, Set<Var> vars, Map<NodeId, Node> nodes) {
        NodeId nodeId = new NodeId(nodeType, vars);
        if (!nodes.containsKey(nodeId)) {
            nodes.put(nodeId, new Node(nodeId));
        }
        return nodes.get(nodeId);
    }

    public Set<Fragment> getFragmentsWithoutDependency() {
        return this.fragmentsWithoutDependency;
    }

    public Set<Fragment> getFragmentsWithDependency() {
        return this.fragmentsWithDependency;
    }

    public Set<Fragment> getFragmentsWithDependencyVisited() {
        return this.fragmentsWithDependencyVisited;
    }

    public Set<Fragment> getDependants() {
        return this.dependants;
    }

    public boolean isValidStartingPoint() {
        return this.isValidStartingPoint;
    }

    public void setInvalidStartingPoint() {
        this.isValidStartingPoint = false;
    }

    public double getFixedFragmentCost() {
        return this.fixedFragmentCost;
    }

    public void setFixedFragmentCost(double fixedFragmentCost) {
        if (this.fixedFragmentCost < fixedFragmentCost) {
            this.fixedFragmentCost = fixedFragmentCost;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node that = (Node)o;
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return this.nodeId.toString();
    }
}

