/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.GraknTx;
import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.hal.HALConceptData;
import ai.grakn.graql.internal.hal.HALExploreInstance;
import ai.grakn.graql.internal.hal.HALExploreSchemaConcept;
import ai.grakn.graql.internal.hal.HALGeneratedRelationship;
import ai.grakn.graql.internal.hal.HALUtils;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HALBuilder.class);
    private static final int MATCH_QUERY_FIXED_DEGREE = 0;
    private static final String ASSERTION_URL = "?keyspace=%s&query=match %s %s %s %s; %s &limitEmbedded=%s&infer=false&materialise=false";

    public static Json renderHALArrayData(GetQuery getQuery, int offset, int limit) {
        Collection answers = (Collection)getQuery.execute();
        return HALBuilder.renderHALArrayData(getQuery, answers, offset, limit, false);
    }

    public static Json renderHALArrayData(GetQuery getQuery, Collection<Answer> results, int offset, int limit, boolean filterInstances) {
        Keyspace keyspace = ((GraknTx)getQuery.tx().get()).getKeyspace();
        HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes = new HashMap();
        if (results.iterator().hasNext()) {
            roleTypes = HALUtils.computeRoleTypesFromQuery(getQuery, results.iterator().next());
        }
        Set<Label> typesAskedInQuery = getQuery.match().admin().getSchemaConcepts().stream().map(SchemaConcept::getLabel).collect(Collectors.toSet());
        return HALBuilder.buildHALRepresentations(results, typesAskedInQuery, roleTypes, keyspace, offset, limit, filterInstances);
    }

    public static String renderHALConceptData(Concept concept, int separationDegree, Keyspace keyspace, int offset, int limit) {
        return new HALConceptData(concept, separationDegree, false, new HashSet<Label>(), keyspace, offset, limit).render();
    }

    @Nullable
    public static String HALExploreConcept(Concept concept, Keyspace keyspace, int offset, int limit) {
        String renderedHAL = null;
        if (concept.isThing()) {
            renderedHAL = new HALExploreInstance(concept, keyspace, offset, limit).render();
        }
        if (concept.isSchemaConcept()) {
            renderedHAL = new HALExploreSchemaConcept(concept, keyspace, offset, limit).render();
        }
        return renderedHAL;
    }

    public static Json explanationAnswersToHAL(Stream<Answer> answerStream, int limit) {
        Json conceptsArray = Json.array();
        answerStream.forEach(answer -> {
            AnswerExplanation expl = answer.getExplanation();
            if (expl.isLookupExplanation()) {
                HALBuilder.renderHALArrayData(expl.getQuery().getQuery(), Collections.singletonList(answer), 0, limit, true).asList().forEach(arg_0 -> ((Json)conceptsArray).add(arg_0));
            } else if (expl.isRuleExplanation()) {
                Atom innerAtom = ((RuleExplanation)expl).getRule().getHead().getAtom();
                if (innerAtom.isRelation()) {
                    HALBuilder.renderHALArrayData(expl.getQuery().getQuery(), Collections.singletonList(answer), 0, limit, true).asList().forEach(arg_0 -> ((Json)conceptsArray).add(arg_0));
                }
                HALBuilder.explanationAnswersToHAL(expl.getAnswers().stream(), limit).asList().forEach(arg_0 -> ((Json)conceptsArray).add(arg_0));
            }
        });
        return conceptsArray;
    }

    private static Json buildHALRepresentations(Collection<Answer> graqlResultsList, Set<Label> typesAskedInQuery, Map<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes, Keyspace keyspace, int offset, int limit, boolean filterInstances) {
        Json lines = Json.array();
        graqlResultsList.forEach(answer -> {
            Map<VarPatternAdmin, Boolean> inferredRelationships = HALUtils.buildInferredRelationshipsMap(answer);
            HashMap<Var, Representation> mapFromVarNameToHALObject = new HashMap<Var, Representation>();
            Stream<Object> entriesStream = answer.map().entrySet().stream();
            if (filterInstances) {
                entriesStream = entriesStream.filter(entry -> ((Concept)entry.getValue()).isThing());
            }
            entriesStream.forEach(currentMapEntry -> {
                Concept currentConcept = (Concept)currentMapEntry.getValue();
                LOG.trace("Building HAL resource for concept with id {}", (Object)currentConcept.getId().getValue());
                Representation currentHal = new HALConceptData(currentConcept, 0, true, typesAskedInQuery, keyspace, offset, limit).getRepresentation();
                mapFromVarNameToHALObject.put((Var)currentMapEntry.getKey(), currentHal);
                Json jsonRepresentation = Json.read((String)currentHal.toString("application/hal+json"));
                if (!answer.getExplanation().isEmpty() && currentConcept.isRelationship() && !filterInstances) {
                    jsonRepresentation.set("_baseType", (Object)"inferred-relationship");
                    jsonRepresentation.at("_links").set("self", Json.object().set("href", (Object)HALBuilder.computeHrefInferred(currentConcept, keyspace, limit)));
                }
                lines.add(jsonRepresentation);
            });
            mapFromVarNameToHALObject.values().forEach(hal -> hal.withProperty("_direction", (Object)"OUT"));
            HALBuilder.loopThroughRelationships(roleTypes, mapFromVarNameToHALObject, answer.map(), keyspace, limit, inferredRelationships).forEach(generatedRelationship -> lines.add(Json.read((String)generatedRelationship.toString("application/hal+json"))));
        });
        return lines;
    }

    private static String computeHrefInferred(Concept currentConcept, Keyspace keyspace, int limit) {
        HashSet thingSet = new HashSet();
        currentConcept.asRelationship().allRolePlayers().values().forEach(set -> set.forEach(thingSet::add));
        String isaString = "isa " + currentConcept.asRelationship().type().getLabel();
        StringBuilder stringBuilderVarsWithIds = new StringBuilder();
        StringBuilder stringBuilderParenthesis = new StringBuilder().append('(');
        char currentVarLetter = 'a';
        for (Thing var : thingSet) {
            stringBuilderVarsWithIds.append(" $").append(currentVarLetter).append(" id '").append(var.getId().getValue()).append("';");
            char c = currentVarLetter;
            currentVarLetter = (char)(currentVarLetter + '\u0001');
            stringBuilderParenthesis.append("$").append(c).append(",");
        }
        String varsWithIds = stringBuilderVarsWithIds.toString();
        String parenthesis = stringBuilderParenthesis.deleteCharAt(stringBuilderParenthesis.length() - 1).append(')').toString();
        String withoutUrl = String.format(ASSERTION_URL, keyspace, varsWithIds, "", parenthesis, isaString, "get;", limit);
        String URL2 = "/dashboard/explain";
        return URL2 + withoutUrl;
    }

    private static Collection<Representation> loopThroughRelationships(Map<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes, Map<Var, Representation> mapFromVarNameToHALObject, Map<Var, Concept> resultLine, Keyspace keyspace, int limit, Map<VarPatternAdmin, Boolean> inferredRelationships) {
        ArrayList<Representation> generatedRelationships = new ArrayList<Representation>();
        roleTypes.entrySet().forEach(currentEntry -> {
            Set<Var> varNamesInCurrentRelationship = ((Map)((Pair)currentEntry.getValue()).getKey()).keySet();
            String idsList = varNamesInCurrentRelationship.stream().map(key -> ((Concept)resultLine.get(key)).getId().getValue()).sorted().collect(Collectors.joining(""));
            String relationshipId = "temp-assertion-" + idsList;
            String relationshipType = (String)((Pair)currentEntry.getValue()).getValue();
            boolean isInferred = inferredRelationships.containsKey(currentEntry.getKey()) && (Boolean)inferredRelationships.get(currentEntry.getKey()) != false;
            String relationshipHref = HALBuilder.computeRelationshipHref(relationshipType, varNamesInCurrentRelationship, resultLine, (Map)((Pair)currentEntry.getValue()).getKey(), keyspace, limit, isInferred);
            Representation genRelationship = new HALGeneratedRelationship().getNewGeneratedRelationship(relationshipId, relationshipHref, relationshipType, isInferred);
            varNamesInCurrentRelationship.forEach(varName -> genRelationship.withRepresentation((String)((Map)((Pair)currentEntry.getValue()).getKey()).get(varName), (ReadableRepresentation)mapFromVarNameToHALObject.get(varName)));
            generatedRelationships.add(genRelationship);
        });
        return generatedRelationships;
    }

    private static String computeRelationshipHref(String relationshipType, Collection<Var> varNamesInCurrentRelationship, Map<Var, Concept> resultLine, Map<Var, String> varNameToRole, Keyspace keyspace, int limit, boolean isInferred) {
        String isaString = !relationshipType.equals("") ? "isa " + relationshipType : "";
        StringBuilder stringBuilderVarsWithIds = new StringBuilder();
        StringBuilder stringBuilderParenthesis = new StringBuilder().append('(');
        char currentVarLetter = 'a';
        for (Var varName : varNamesInCurrentRelationship) {
            String id = resultLine.get(varName).getId().getValue();
            stringBuilderVarsWithIds.append(" $").append(currentVarLetter).append(" id '").append(id).append("';");
            String role = varNameToRole.get(varName).equals("EMPTY-GRAKN-ROLE") ? "" : varNameToRole.get(varName) + ":";
            char c = currentVarLetter;
            currentVarLetter = (char)(currentVarLetter + '\u0001');
            stringBuilderParenthesis.append(role).append("$").append(c).append(",");
        }
        String varsWithIds = stringBuilderVarsWithIds.toString();
        String parenthesis = stringBuilderParenthesis.deleteCharAt(stringBuilderParenthesis.length() - 1).append(')').toString();
        String dollarR = isInferred ? "" : "$r";
        String getR = isInferred ? "get;" : "get $r;";
        String withoutUrl = String.format(ASSERTION_URL, keyspace, varsWithIds, dollarR, parenthesis, isaString, getR, limit);
        String URL2 = isInferred ? "/dashboard/explain" : "/kb/graql";
        return URL2 + withoutUrl;
    }
}

