/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.graql.internal.hal.HALUtils;
import ai.grakn.util.Schema;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class HALConceptData {
    private final RepresentationFactory factory;
    private final Representation halResource;
    private final String resourceLinkPrefix;
    private final Keyspace keyspace;
    private final boolean embedType;
    private final Set<Label> typesInQuery;
    private final int offset;
    private final int limit;

    public HALConceptData(Concept concept, int separationDegree, boolean embedTypeParam, Set<Label> typesInQuery, Keyspace keyspace, int offset, int limit) {
        this.embedType = embedTypeParam;
        this.typesInQuery = typesInQuery;
        this.offset = offset;
        this.limit = limit;
        this.keyspace = keyspace;
        this.resourceLinkPrefix = "/kb/concept/";
        this.factory = new StandardRepresentationFactory();
        int uriOffset = separationDegree > 0 && limit >= 0 ? offset + limit : offset;
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId() + this.getURIParams(uriOffset));
        this.handleConcept(this.halResource, concept, separationDegree);
    }

    private String getURIParams(int offset) {
        String limitParam = this.limit >= 0 ? "&limitEmbedded=" + this.limit : "";
        return "?keyspace=" + this.keyspace + "&" + "offsetEmbedded" + "=" + offset + limitParam;
    }

    private void handleConcept(Representation halResource, Concept concept, int separationDegree) {
        Thing thing;
        this.generateStateAndLinks(halResource, concept);
        if (this.embedType && concept.isThing() && (this.typesInQuery.contains((thing = concept.asThing()).type().getLabel()) || thing.type().sup() != null && this.typesInQuery.contains(thing.type().sup().getLabel()))) {
            this.embedType(halResource, thing);
        }
        if (concept.isType() && concept.asType().sup() != null) {
            this.embedSuperType(halResource, concept.asType());
        }
        if (concept.isRelationship() && separationDegree == 0) {
            this.generateRelationEmbedded(halResource, concept.asRelationship(), 1);
        }
        if (concept.isRule() && !Schema.MetaSchema.isMetaLabel((Label)concept.asRule().getLabel())) {
            this.generateRuleLHS(halResource, concept.asRule());
            this.generateRuleRHS(halResource, concept.asRule());
        }
        if (separationDegree == 0) {
            return;
        }
        if (concept.isEntity()) {
            this.generateEntityEmbedded(halResource, concept.asEntity(), separationDegree);
        }
        if (concept.isRelationship()) {
            this.generateRelationEmbedded(halResource, concept.asRelationship(), separationDegree);
            this.embedRelationsPlays(halResource, concept.asRelationship());
        }
        if (concept.isAttribute()) {
            this.generateOwnerInstances(halResource, concept.asAttribute(), separationDegree);
        }
        if (concept.isType()) {
            this.generateTypeEmbedded(halResource, concept.asType(), separationDegree);
        }
    }

    private void generateRuleRHS(Representation halResource, Rule rule) {
        Representation RHS = this.factory.newRepresentation(this.resourceLinkPrefix + "RHS-" + rule.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT").withLink("explore", "/dashboard/explore/").withProperty("_id", (Object)("RHS-" + rule.getId().getValue())).withProperty("_type", (Object)"RHS").withProperty("_baseType", (Object)Schema.BaseType.ATTRIBUTE_TYPE.name()).withProperty("_value", (Object)rule.getThen().admin().toString());
        halResource.withRepresentation("RHS", (ReadableRepresentation)RHS);
    }

    private void generateRuleLHS(Representation halResource, Rule rule) {
        Representation LHS = this.factory.newRepresentation(this.resourceLinkPrefix + "LHS-" + rule.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT").withLink("explore", "/dashboard/explore/").withProperty("_id", (Object)("LHS-" + rule.getId().getValue())).withProperty("_type", (Object)"LHS").withProperty("_baseType", (Object)Schema.BaseType.ATTRIBUTE_TYPE.name()).withProperty("_value", (Object)rule.getWhen().admin().toString());
        halResource.withRepresentation("LHS", (ReadableRepresentation)LHS);
    }

    private void generateOwnerInstances(Representation halResource, Attribute<?> conceptAttribute, int separationDegree) {
        Label roleType = conceptAttribute.type().getLabel();
        Stream<Thing> ownersStream = conceptAttribute.ownerInstances().skip(this.offset);
        if (this.limit >= 0) {
            ownersStream = ownersStream.limit(this.limit);
        }
        ownersStream.forEach(instance -> {
            Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
            this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
            halResource.withRepresentation(roleType.getValue(), (ReadableRepresentation)instanceResource);
        });
    }

    private void embedSuperType(Representation halResource, Type type) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + type.sup().getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT");
        this.generateStateAndLinks(HALType, (Concept)type.sup());
        halResource.withRepresentation(HALUtils.SUB_EDGE, (ReadableRepresentation)HALType);
    }

    private void embedType(Representation halResource, Thing thing) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + thing.type().getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT");
        this.generateStateAndLinks(HALType, (Concept)thing.type());
        halResource.withRepresentation(HALUtils.ISA_EDGE, (ReadableRepresentation)HALType);
    }

    private void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink("explore", "/dashboard/explore/" + concept.getId() + this.getURIParams(0));
        HALUtils.generateConceptState(resource, concept);
    }

    private void generateEntityEmbedded(Representation halResource, Entity entity, int separationDegree) {
        Stream<Relationship> relationStream = entity.relationships(new Role[0]);
        relationStream = relationStream.skip(this.offset);
        if (this.limit >= 0) {
            relationStream = relationStream.limit(this.limit);
        }
        relationStream.forEach(rel -> this.embedRelationsNotConnectedToAttributes(halResource, (Concept)entity, (Relationship)rel, separationDegree));
    }

    private void attachRelation(Representation halResource, Concept rel, Label role, int separationDegree) {
        Representation relationResource = this.factory.newRepresentation(this.resourceLinkPrefix + rel.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
        this.handleConcept(relationResource, rel, separationDegree - 1);
        halResource.withRepresentation(role.getValue(), (ReadableRepresentation)relationResource);
    }

    private void generateRelationEmbedded(Representation halResource, Relationship rel, int separationDegree) {
        rel.allRolePlayers().forEach((roleType, instanceSet) -> instanceSet.forEach(instance -> {
            if (instance != null) {
                Representation roleResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"OUT");
                if (!instance.isRelationship()) {
                    this.handleConcept(roleResource, (Concept)instance, separationDegree - 1);
                } else {
                    this.generateStateAndLinks(roleResource, (Concept)instance);
                }
                halResource.withRepresentation(roleType.getLabel().getValue(), (ReadableRepresentation)roleResource);
            }
        }));
    }

    private void embedRelationsNotConnectedToAttributes(Representation halResource, Concept concept, Relationship relationship, int separationDegree) {
        Label rolePlayedByCurrentConcept = null;
        boolean isAttribute = false;
        for (Map.Entry entry : relationship.allRolePlayers().entrySet()) {
            for (Thing thing : (Set)entry.getValue()) {
                if (thing == null) continue;
                if (thing.isAttribute()) {
                    isAttribute = true;
                    continue;
                }
                if (!thing.getId().equals(concept.getId())) continue;
                rolePlayedByCurrentConcept = ((Role)entry.getKey()).getLabel();
            }
        }
        if (!isAttribute) {
            this.attachRelation(halResource, (Concept)relationship, rolePlayedByCurrentConcept, separationDegree);
        }
    }

    private void embedRelationsPlays(Representation halResource, Relationship rel) {
        rel.plays().forEach(roleTypeRel -> rel.relationships(new Role[]{roleTypeRel}).forEach(relation -> this.embedRelationsNotConnectedToAttributes(halResource, (Concept)rel, (Relationship)relation, 1)));
    }

    private void generateTypeEmbedded(Representation halResource, Type type, int separationDegree) {
        if (!type.getLabel().equals(Schema.MetaSchema.THING.getLabel())) {
            Stream<Thing> instancesStream = type.instances().skip(this.offset);
            if (this.limit >= 0) {
                instancesStream = instancesStream.limit(this.limit);
            }
            instancesStream.forEach(instance -> {
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
                this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(HALUtils.ISA_EDGE, (ReadableRepresentation)instanceResource);
            });
        }
        type.subs().filter(sub -> !sub.getLabel().equals(type.getLabel())).forEach(sub -> {
            Representation subResource = this.factory.newRepresentation(this.resourceLinkPrefix + sub.getId() + this.getURIParams(0)).withProperty("_direction", (Object)"IN");
            this.handleConcept(subResource, (Concept)sub, separationDegree - 1);
            halResource.withRepresentation(HALUtils.SUB_EDGE, (ReadableRepresentation)subResource);
        });
    }

    public String render() {
        return this.halResource.toString("application/hal+json");
    }

    public Representation getRepresentation() {
        return this.halResource;
    }
}

