/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.graql.internal.hal.HALUtils;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;

abstract class HALExploreConcept {
    final RepresentationFactory factory;
    final Representation halResource;
    private final Keyspace keyspace;
    private final int limit;
    private final int offset;
    final String resourceLinkPrefix;

    HALExploreConcept(Concept concept, Keyspace keyspace, int offset, int limit) {
        this.resourceLinkPrefix = "/kb/concept/";
        this.keyspace = keyspace;
        this.offset = offset;
        this.limit = limit;
        this.factory = new StandardRepresentationFactory();
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId() + this.getURIParams());
        this.generateStateAndLinks(this.halResource, concept);
        this.populateEmbedded(this.halResource, concept);
    }

    String getURIParams() {
        String limitParam = this.limit >= 0 ? "&limitEmbedded=" + this.limit : "";
        return "?keyspace=" + this.keyspace + "&" + "offsetEmbedded" + "=" + this.offset + limitParam;
    }

    void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink("explore", "/dashboard/explore/" + concept.getId() + this.getURIParams());
        HALUtils.generateConceptState(resource, concept);
    }

    abstract void populateEmbedded(Representation var1, Concept var2);

    public String render() {
        return this.halResource.toString("application/hal+json");
    }
}

