/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.graql.internal.hal.HALExploreConcept;
import ai.grakn.graql.internal.hal.HALUtils;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.stream.Stream;

class HALExploreSchemaConcept
extends HALExploreConcept {
    HALExploreSchemaConcept(Concept concept, Keyspace keyspace, int offset, int limit) {
        super(concept, keyspace, offset, limit);
    }

    @Override
    void populateEmbedded(Representation halResource, Concept concept) {
        SchemaConcept schemaConcept = concept.asSchemaConcept();
        if (schemaConcept.isType()) {
            this.attachRolesPlayed(halResource, schemaConcept.asType().plays());
            this.attachTypeResources(halResource, schemaConcept.asType());
        }
        this.attachSubTypes(halResource, schemaConcept);
        if (schemaConcept.isRelationshipType()) {
            this.relationshipTypeRoles(halResource, schemaConcept.asRelationshipType());
        } else if (schemaConcept.isRole()) {
            this.roleTypeSchema(halResource, schemaConcept.asRole());
        }
    }

    private void attachSubTypes(Representation halResource, SchemaConcept schemaConcept) {
        schemaConcept.subs().forEach(instance -> {
            if (!instance.getId().equals(schemaConcept.getId())) {
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.getURIParams()).withProperty("_direction", (Object)"IN");
                this.generateStateAndLinks(instanceResource, (Concept)instance);
                halResource.withRepresentation(HALUtils.SUB_EDGE, (ReadableRepresentation)instanceResource);
            }
        });
    }

    private void roleTypeSchema(Representation halResource, Role role) {
        role.playedByTypes().forEach(type -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + type.getId() + this.getURIParams()).withProperty("_direction", (Object)"IN");
            this.generateStateAndLinks(roleRepresentation, (Concept)type);
            halResource.withRepresentation(HALUtils.PLAYS_EDGE, (ReadableRepresentation)roleRepresentation);
        });
        role.relationshipTypes().forEach(relType -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + relType.getId() + this.getURIParams()).withProperty("_direction", (Object)"IN");
            this.generateStateAndLinks(roleRepresentation, (Concept)relType);
            halResource.withRepresentation(HALUtils.RELATES_EDGE, (ReadableRepresentation)roleRepresentation);
        });
    }

    private void relationshipTypeRoles(Representation halResource, RelationshipType relationshipType) {
        relationshipType.relates().forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId() + this.getURIParams()).withProperty("_direction", (Object)"OUT");
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            this.roleTypeSchema(roleRepresentation, (Role)role);
            halResource.withRepresentation(HALUtils.RELATES_EDGE, (ReadableRepresentation)roleRepresentation);
        });
    }

    private void attachTypeResources(Representation halResource, Type conceptType) {
        conceptType.attributes().forEach(currentAttributeType -> {
            Representation embeddedResource = this.factory.newRepresentation(this.resourceLinkPrefix + currentAttributeType.getId() + this.getURIParams()).withProperty("_direction", (Object)"OUT");
            this.generateStateAndLinks(embeddedResource, (Concept)currentAttributeType);
            halResource.withRepresentation("has", (ReadableRepresentation)embeddedResource);
        });
    }

    private void attachRolesPlayed(Representation halResource, Stream<Role> roles) {
        roles.forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId() + this.getURIParams()).withProperty("_direction", (Object)"OUT");
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            this.roleTypeSchema(roleRepresentation, (Role)role);
            halResource.withRepresentation(HALUtils.PLAYS_EDGE, (ReadableRepresentation)roleRepresentation);
        });
    }

    @Override
    public String render() {
        return this.halResource.toString("application/hal+json");
    }
}

