/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationshipProperty;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class HALUtils {
    static final String EXPLORE_CONCEPT_LINK = "explore";
    static final String ISA_EDGE = Schema.EdgeLabel.ISA.getLabel();
    static final String SUB_EDGE = Schema.EdgeLabel.SUB.getLabel();
    static final String OUTBOUND_EDGE = "OUT";
    static final String INBOUND_EDGE = "IN";
    static final String RELATES_EDGE = Schema.EdgeLabel.RELATES.getLabel();
    static final String HAS_EDGE = "has";
    static final String PLAYS_EDGE = Schema.EdgeLabel.PLAYS.getLabel();
    static final String HAS_EMPTY_ROLE_EDGE = "EMPTY-GRAKN-ROLE";
    public static final String ID_PROPERTY = "_id";
    public static final String TYPE_PROPERTY = "_type";
    public static final String BASETYPE_PROPERTY = "_baseType";
    public static final String DIRECTION_PROPERTY = "_direction";
    public static final String VALUE_PROPERTY = "_value";
    public static final String DATATYPE_PROPERTY = "_dataType";
    public static final String NAME_PROPERTY = "_name";
    public static final String LINKS_PROPERTY = "_links";
    public static final String INFERRED_RELATIONSHIP = "inferred-relationship";
    public static final String GENERATED_RELATIONSHIP = "generated-relationship";
    public static final String IMPLICIT_PROPERTY = "_implicit";

    static Schema.BaseType getBaseType(Thing thing) {
        if (thing.isEntity()) {
            return Schema.BaseType.ENTITY;
        }
        if (thing.isRelationship()) {
            return Schema.BaseType.RELATIONSHIP;
        }
        if (thing.isAttribute()) {
            return Schema.BaseType.ATTRIBUTE;
        }
        throw CommonUtil.unreachableStatement((String)("Unrecognised base type of " + thing));
    }

    static Schema.BaseType getBaseType(SchemaConcept schemaConcept) {
        if (schemaConcept.isEntityType()) {
            return Schema.BaseType.ENTITY_TYPE;
        }
        if (schemaConcept.isRelationshipType()) {
            return Schema.BaseType.RELATIONSHIP_TYPE;
        }
        if (schemaConcept.isAttributeType()) {
            return Schema.BaseType.ATTRIBUTE_TYPE;
        }
        if (schemaConcept.isRule()) {
            return Schema.BaseType.RULE;
        }
        if (schemaConcept.isRole()) {
            return Schema.BaseType.ROLE;
        }
        if (schemaConcept.getLabel().equals(Schema.MetaSchema.THING.getLabel())) {
            return Schema.BaseType.TYPE;
        }
        throw CommonUtil.unreachableStatement((String)("Unrecognised base type of " + schemaConcept));
    }

    static void generateConceptState(Representation resource, Concept concept) {
        resource.withProperty(ID_PROPERTY, (Object)concept.getId().getValue());
        if (concept.isThing()) {
            Thing thing = concept.asThing();
            resource.withProperty(TYPE_PROPERTY, (Object)thing.type().getLabel().getValue()).withProperty(BASETYPE_PROPERTY, (Object)HALUtils.getBaseType(thing).name());
        } else {
            resource.withProperty(BASETYPE_PROPERTY, (Object)HALUtils.getBaseType(concept.asSchemaConcept()).name());
        }
        if (concept.isAttribute()) {
            resource.withProperty(VALUE_PROPERTY, concept.asAttribute().getValue());
            resource.withProperty(DATATYPE_PROPERTY, (Object)concept.asAttribute().dataType().getName());
        }
        if (concept.isSchemaConcept()) {
            resource.withProperty(NAME_PROPERTY, (Object)concept.asSchemaConcept().getLabel().getValue());
            resource.withProperty(IMPLICIT_PROPERTY, (Object)((SchemaConcept)concept).isImplicit());
            if (concept.isAttributeType()) {
                String dataType = Optional.ofNullable(concept.asAttributeType().getDataType()).map(x -> x.getName()).orElse("");
                resource.withProperty(DATATYPE_PROPERTY, (Object)dataType);
            }
        }
    }

    static Map<VarPatternAdmin, Pair<Map<Var, String>, String>> computeRoleTypesFromQuery(GetQuery getQuery, Answer firstAnswer) {
        HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes = new HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>>();
        AnswerExplanation firstExplanation = firstAnswer.getExplanation();
        if (firstExplanation.isEmpty()) {
            return HALUtils.computeRoleTypesFromQueryNoReasoner(getQuery);
        }
        if (firstExplanation.isRuleExplanation() || firstExplanation.isLookupExplanation()) {
            HALUtils.updateRoleTypesFromAnswer(roleTypes, firstAnswer, getQuery);
        } else {
            firstAnswer.getExplanation().getAnswers().forEach(answer -> HALUtils.updateRoleTypesFromAnswer(roleTypes, answer, getQuery));
        }
        return roleTypes;
    }

    private static void updateRoleTypesFromAnswer(Map<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes, Answer answer, GetQuery getQuery) {
        Atom atom = ((ReasonerAtomicQuery)answer.getExplanation().getQuery()).getAtom();
        if (atom.isRelation()) {
            Optional<VarPatternAdmin> var = atom.getPattern().varPatterns().stream().filter(x -> x.hasProperty(RelationshipProperty.class)).findFirst();
            VarPatternAdmin varAdmin = atom.getPattern().asVarPattern();
            if (var.isPresent() && !var.get().var().isUserDefinedName() && HALUtils.bothRolePlayersAreSelected(atom, getQuery)) {
                roleTypes.put(varAdmin, HALUtils.pairVarNamesRelationshipType(atom));
            }
        }
    }

    private static boolean bothRolePlayersAreSelected(Atom atom, GetQuery getQuery) {
        RelationshipAtom reasonerRel = (RelationshipAtom)atom;
        Set rolePlayersInAtom = reasonerRel.getRolePlayers().stream().collect(Collectors.toSet());
        Set selectedVars = getQuery.vars();
        return Sets.intersection(rolePlayersInAtom, (Set)selectedVars).equals(rolePlayersInAtom);
    }

    private static boolean bothRolePlayersAreSelectedNoReasoner(VarPatternAdmin var, GetQuery getQuery) {
        Set rolePlayersInVar = ((RelationshipProperty)var.getProperty(RelationshipProperty.class).get()).relationPlayers().stream().map(x -> x.getRolePlayer().var()).collect(Collectors.toSet());
        Set selectedVars = getQuery.vars();
        return Sets.intersection(rolePlayersInVar, (Set)selectedVars).equals(rolePlayersInVar);
    }

    private static Map<VarPatternAdmin, Pair<Map<Var, String>, String>> computeRoleTypesFromQueryNoReasoner(GetQuery getQuery) {
        HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes = new HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>>();
        getQuery.match().admin().getPattern().varPatterns().forEach(var -> {
            if (var.getProperty(RelationshipProperty.class).isPresent() && !var.var().isUserDefinedName() && HALUtils.bothRolePlayersAreSelectedNoReasoner(var, getQuery)) {
                Optional relOptional;
                HashMap tempMap = new HashMap();
                ((RelationshipProperty)var.getProperty(RelationshipProperty.class).get()).relationPlayers().forEach(x -> tempMap.put(x.getRolePlayer().var(), x.getRole().isPresent() ? ((VarPatternAdmin)x.getRole().get()).getPrintableName() : HAS_EMPTY_ROLE_EDGE));
                String relationshipType = null;
                relationshipType = var.getProperty(IsaProperty.class).isPresent() ? ((relOptional = ((IsaProperty)var.getProperty(IsaProperty.class).get()).type().getTypeLabel()).isPresent() ? ((Label)relOptional.get()).getValue() : "") : "";
                roleTypes.put((VarPatternAdmin)var, new Pair(tempMap, relationshipType));
            }
        });
        return roleTypes;
    }

    private static Pair<Map<Var, String>, String> pairVarNamesRelationshipType(Atom atom) {
        RelationshipAtom reasonerRel = (RelationshipAtom)atom;
        HashMap varNamesToRole = new HashMap();
        reasonerRel.getRolePlayers().forEach(varName -> varNamesToRole.put(varName, HAS_EMPTY_ROLE_EDGE));
        reasonerRel.getRoleVarMap().entries().stream().filter(entry -> !Schema.MetaSchema.isMetaLabel((Label)((Role)entry.getKey()).getLabel())).forEach(entry -> varNamesToRole.put(entry.getValue(), ((Role)entry.getKey()).getLabel().getValue()));
        String relationshipType = reasonerRel.getSchemaConcept() != null ? reasonerRel.getSchemaConcept().getLabel().getValue() : "";
        return new Pair<Map<Var, String>, String>(varNamesToRole, relationshipType);
    }

    static Map<VarPatternAdmin, Boolean> buildInferredRelationshipsMap(Answer firstAnswer) {
        HashMap<VarPatternAdmin, Boolean> inferredRelationships = new HashMap<VarPatternAdmin, Boolean>();
        AnswerExplanation firstExplanation = firstAnswer.getExplanation();
        if (firstExplanation.isRuleExplanation() || firstExplanation.isLookupExplanation()) {
            Atom atom = ((ReasonerAtomicQuery)firstAnswer.getExplanation().getQuery()).getAtom();
            if (atom.isRelation()) {
                VarPatternAdmin varAdmin = atom.getPattern().asVarPattern();
                inferredRelationships.put(varAdmin, firstAnswer.getExplanation().isRuleExplanation());
            }
        } else {
            firstAnswer.getExplanation().getAnswers().forEach(answer -> {
                Atom atom = ((ReasonerAtomicQuery)answer.getExplanation().getQuery()).getAtom();
                if (atom.isRelation()) {
                    VarPatternAdmin varAdmin = atom.getPattern().asVarPattern();
                    inferredRelationships.put(varAdmin, answer.getExplanation().isRuleExplanation());
                }
            });
        }
        return inferredRelationships;
    }
}

