/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.DefineQuery;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.NamedAggregate;
import ai.grakn.graql.Order;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.analytics.ClusterQuery;
import ai.grakn.graql.analytics.CountQuery;
import ai.grakn.graql.analytics.DegreeQuery;
import ai.grakn.graql.analytics.MaxQuery;
import ai.grakn.graql.analytics.MeanQuery;
import ai.grakn.graql.analytics.MedianQuery;
import ai.grakn.graql.analytics.MinQuery;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.analytics.StdQuery;
import ai.grakn.graql.analytics.SumQuery;
import ai.grakn.graql.internal.antlr.GraqlBaseVisitor;
import ai.grakn.graql.internal.antlr.GraqlParser;
import ai.grakn.graql.internal.parser.QueryParser;
import ai.grakn.util.StringUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryVisitor
extends GraqlBaseVisitor {
    protected final Logger LOG = LoggerFactory.getLogger(QueryVisitor.class);
    private final QueryBuilder queryBuilder;
    private final ImmutableMap<String, Function<List<Object>, Aggregate>> aggregateMethods;

    QueryVisitor(ImmutableMap<String, Function<List<Object>, Aggregate>> aggregateMethods, QueryBuilder queryBuilder) {
        this.aggregateMethods = aggregateMethods;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public Stream<? extends Query<?>> visitQueryList(GraqlParser.QueryListContext ctx) {
        return ctx.query().stream().map(this::visitQuery);
    }

    @Override
    public Query<?> visitQueryEOF(GraqlParser.QueryEOFContext ctx) {
        return this.visitQuery(ctx.query());
    }

    @Override
    public Query<?> visitQuery(GraqlParser.QueryContext ctx) {
        return (Query)super.visitQuery(ctx);
    }

    @Override
    public Match visitMatchBase(GraqlParser.MatchBaseContext ctx) {
        Object patterns = this.visitPatterns(ctx.patterns());
        return this.queryBuilder.match((Collection)patterns);
    }

    @Override
    public Match visitMatchOffset(GraqlParser.MatchOffsetContext ctx) {
        return this.visitMatchPart(ctx.matchPart()).offset(this.getInteger(ctx.INTEGER()));
    }

    @Override
    public Match visitMatchOrderBy(GraqlParser.MatchOrderByContext ctx) {
        Match match = this.visitMatchPart(ctx.matchPart());
        Var var = this.getVariable(ctx.VARIABLE());
        if (ctx.ORDER() != null) {
            return match.orderBy(var, this.getOrder(ctx.ORDER()));
        }
        return match.orderBy(var);
    }

    @Override
    public Match visitMatchLimit(GraqlParser.MatchLimitContext ctx) {
        return this.visitMatchPart(ctx.matchPart()).limit(this.getInteger(ctx.INTEGER()));
    }

    @Override
    public GetQuery visitGetQuery(GraqlParser.GetQueryContext ctx) {
        Set vars = ctx.VARIABLE().stream().map(this::getVariable).collect(Collectors.toSet());
        Match match = this.visitMatchPart(ctx.matchPart());
        if (vars.isEmpty()) {
            return match.get();
        }
        return match.get(vars);
    }

    @Override
    public InsertQuery visitInsertQuery(GraqlParser.InsertQueryContext ctx) {
        Object vars = this.visitVarPatterns(ctx.varPatterns());
        if (ctx.matchPart() != null) {
            return this.visitMatchPart(ctx.matchPart()).insert((Collection)vars);
        }
        return this.queryBuilder.insert((Collection)vars);
    }

    @Override
    public DefineQuery visitDefineQuery(GraqlParser.DefineQueryContext ctx) {
        Object vars = this.visitVarPatterns(ctx.varPatterns());
        return this.queryBuilder.define((Collection)vars);
    }

    @Override
    public Object visitUndefineQuery(GraqlParser.UndefineQueryContext ctx) {
        Object vars = this.visitVarPatterns(ctx.varPatterns());
        return this.queryBuilder.undefine((Collection)vars);
    }

    @Override
    public DeleteQuery visitDeleteQuery(GraqlParser.DeleteQueryContext ctx) {
        ImmutableSet vars = ctx.variables() != null ? this.visitVariables(ctx.variables()) : ImmutableSet.of();
        return this.visitMatchPart(ctx.matchPart()).delete((Collection)vars);
    }

    @Override
    public ComputeQuery<?> visitComputeQuery(GraqlParser.ComputeQueryContext ctx) {
        return this.visitComputeMethod(ctx.computeMethod());
    }

    @Override
    public Set<Var> visitVariables(GraqlParser.VariablesContext ctx) {
        return ctx.VARIABLE().stream().map(this::getVariable).collect(Collectors.toSet());
    }

    @Override
    public MinQuery visitMin(GraqlParser.MinContext ctx) {
        MinQuery min = this.queryBuilder.compute().min().of((Collection)this.visitOfList(ctx.ofList()));
        if (ctx.inList() != null) {
            min = min.in((Collection)this.visitInList(ctx.inList()));
        }
        return min;
    }

    @Override
    public MaxQuery visitMax(GraqlParser.MaxContext ctx) {
        MaxQuery max = this.queryBuilder.compute().max().of((Collection)this.visitOfList(ctx.ofList()));
        if (ctx.inList() != null) {
            max = max.in((Collection)this.visitInList(ctx.inList()));
        }
        return max;
    }

    @Override
    public MedianQuery visitMedian(GraqlParser.MedianContext ctx) {
        MedianQuery median = this.queryBuilder.compute().median().of((Collection)this.visitOfList(ctx.ofList()));
        if (ctx.inList() != null) {
            median = median.in((Collection)this.visitInList(ctx.inList()));
        }
        return median;
    }

    @Override
    public MeanQuery visitMean(GraqlParser.MeanContext ctx) {
        MeanQuery mean = this.queryBuilder.compute().mean();
        if (ctx.ofList() != null) {
            mean = mean.of((Collection)this.visitOfList(ctx.ofList()));
        }
        if (ctx.inList() != null) {
            mean = mean.in((Collection)this.visitInList(ctx.inList()));
        }
        return mean;
    }

    @Override
    public StdQuery visitStd(GraqlParser.StdContext ctx) {
        StdQuery std = this.queryBuilder.compute().std().of((Collection)this.visitOfList(ctx.ofList()));
        if (ctx.inList() != null) {
            std = std.in((Collection)this.visitInList(ctx.inList()));
        }
        return std;
    }

    @Override
    public SumQuery visitSum(GraqlParser.SumContext ctx) {
        SumQuery sum = this.queryBuilder.compute().sum().of((Collection)this.visitOfList(ctx.ofList()));
        if (ctx.inList() != null) {
            sum = sum.in((Collection)this.visitInList(ctx.inList()));
        }
        return sum;
    }

    @Override
    public CountQuery visitCount(GraqlParser.CountContext ctx) {
        CountQuery count = this.queryBuilder.compute().count();
        if (ctx.inList() != null) {
            count = count.in((Collection)this.visitInList(ctx.inList()));
        }
        return count;
    }

    @Override
    public PathQuery visitPath(GraqlParser.PathContext ctx) {
        PathQuery path = this.queryBuilder.compute().path().from(this.visitId(ctx.id(0))).to(this.visitId(ctx.id(1)));
        if (ctx.inList() != null) {
            path = path.in((Collection)this.visitInList(ctx.inList()));
        }
        return path;
    }

    @Override
    public ClusterQuery<?> visitCluster(GraqlParser.ClusterContext ctx) {
        ClusterQuery cluster = this.queryBuilder.compute().cluster();
        if (ctx.inList() != null) {
            cluster = cluster.in((Collection)this.visitInList(ctx.inList()));
        }
        cluster = (ClusterQuery)this.chainOperators(ctx.clusterParam().stream().map(this::visitClusterParam)).apply(cluster);
        return cluster;
    }

    private UnaryOperator<ClusterQuery<?>> visitClusterParam(GraqlParser.ClusterParamContext ctx) {
        return (UnaryOperator)this.visit((ParseTree)ctx);
    }

    @Override
    public UnaryOperator<ClusterQuery<?>> visitClusterMembers(GraqlParser.ClusterMembersContext ctx) {
        return ClusterQuery::members;
    }

    @Override
    public UnaryOperator<ClusterQuery<?>> visitClusterSize(GraqlParser.ClusterSizeContext ctx) {
        return query -> query.clusterSize(this.getInteger(ctx.INTEGER()));
    }

    @Override
    public DegreeQuery visitDegrees(GraqlParser.DegreesContext ctx) {
        DegreeQuery degree = this.queryBuilder.compute().degree();
        if (ctx.ofList() != null) {
            degree = degree.of((Collection)this.visitOfList(ctx.ofList()));
        }
        if (ctx.inList() != null) {
            degree = degree.in((Collection)this.visitInList(ctx.inList()));
        }
        return degree;
    }

    @Override
    public ComputeQuery<?> visitComputeMethod(GraqlParser.ComputeMethodContext ctx) {
        return (ComputeQuery)super.visitComputeMethod(ctx);
    }

    @Override
    public Set<Label> visitInList(GraqlParser.InListContext ctx) {
        return this.visitLabelList(ctx.labelList());
    }

    @Override
    public Set<Label> visitOfList(GraqlParser.OfListContext ctx) {
        return this.visitLabelList(ctx.labelList());
    }

    @Override
    public Set<Label> visitLabelList(GraqlParser.LabelListContext ctx) {
        return ctx.label().stream().map(this::visitLabel).collect(Collectors.toSet());
    }

    @Override
    public AggregateQuery<?> visitAggregateQuery(GraqlParser.AggregateQueryContext ctx) {
        Aggregate<?, ?> aggregate = this.visitAggregate(ctx.aggregate());
        return this.visitMatchPart(ctx.matchPart()).aggregate(aggregate);
    }

    @Override
    public Aggregate<?, ?> visitCustomAgg(GraqlParser.CustomAggContext ctx) {
        String name = this.visitIdentifier(ctx.identifier());
        Function aggregateMethod = (Function)this.aggregateMethods.get((Object)name);
        if (aggregateMethod == null) {
            throw GraqlQueryException.unknownAggregate((String)name);
        }
        List arguments = ctx.argument().stream().map(arg_0 -> ((QueryVisitor)this).visit(arg_0)).collect(Collectors.toList());
        return (Aggregate)aggregateMethod.apply(arguments);
    }

    @Override
    public Aggregate<?, ? extends Map<String, ?>> visitSelectAgg(GraqlParser.SelectAggContext ctx) {
        Set aggregates = ctx.namedAgg().stream().map(this::visitNamedAgg).collect(Collectors.toSet());
        return Graql.select(aggregates);
    }

    @Override
    public Var visitVariableArgument(GraqlParser.VariableArgumentContext ctx) {
        return this.getVariable(ctx.VARIABLE());
    }

    @Override
    public Aggregate<?, ?> visitAggregateArgument(GraqlParser.AggregateArgumentContext ctx) {
        return this.visitAggregate(ctx.aggregate());
    }

    @Override
    public NamedAggregate<?, ?> visitNamedAgg(GraqlParser.NamedAggContext ctx) {
        String name = this.visitIdentifier(ctx.identifier());
        return this.visitAggregate(ctx.aggregate()).as(name);
    }

    @Override
    public List<Pattern> visitPatterns(GraqlParser.PatternsContext ctx) {
        return ctx.pattern().stream().map(this::visitPattern).collect(Collectors.toList());
    }

    @Override
    public Pattern visitOrPattern(GraqlParser.OrPatternContext ctx) {
        return Graql.or(ctx.pattern().stream().map(this::visitPattern).collect(Collectors.toList()));
    }

    @Override
    public List<VarPattern> visitVarPatterns(GraqlParser.VarPatternsContext ctx) {
        return ctx.varPattern().stream().map(this::visitVarPattern).collect(Collectors.toList());
    }

    @Override
    public Pattern visitAndPattern(GraqlParser.AndPatternContext ctx) {
        return Graql.and((Collection<? extends Pattern>)this.visitPatterns(ctx.patterns()));
    }

    @Override
    public VarPattern visitVarPattern(GraqlParser.VarPatternContext ctx) {
        Object var = ctx.VARIABLE() != null ? this.getVariable(ctx.VARIABLE()) : this.visitVariable(ctx.variable());
        return (VarPattern)this.getVarProperties(ctx.property()).apply((VarPattern)var);
    }

    @Override
    public UnaryOperator<VarPattern> visitPropId(GraqlParser.PropIdContext ctx) {
        return var -> var.id(this.visitId(ctx.id()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropLabel(GraqlParser.PropLabelContext ctx) {
        return var -> var.label(this.visitLabel(ctx.label()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropValue(GraqlParser.PropValueContext ctx) {
        return var -> var.val(this.visitPredicate(ctx.predicate()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropWhen(GraqlParser.PropWhenContext ctx) {
        return var -> var.when(Graql.and((Collection<? extends Pattern>)this.visitPatterns(ctx.patterns())));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropThen(GraqlParser.PropThenContext ctx) {
        return var -> var.then(Graql.and((Collection<? extends Pattern>)this.visitVarPatterns(ctx.varPatterns())));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropHas(GraqlParser.PropHasContext ctx) {
        Label type = this.visitLabel(ctx.label());
        VarPattern relation = (VarPattern)Optional.ofNullable(ctx.relation).map(this::getVariable).orElseGet(Graql::var);
        VarPattern resource = (VarPattern)Optional.ofNullable(ctx.resource).map(this::getVariable).orElseGet(Graql::var);
        if (ctx.predicate() != null) {
            resource = resource.val(this.visitPredicate(ctx.predicate()));
        }
        VarPattern finalResource = resource;
        return var -> var.has(type, finalResource, relation);
    }

    @Override
    public UnaryOperator<VarPattern> visitPropResource(GraqlParser.PropResourceContext ctx) {
        return var -> var.has(this.visitVariable(ctx.variable()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropKey(GraqlParser.PropKeyContext ctx) {
        return var -> var.key(this.visitVariable(ctx.variable()));
    }

    @Override
    public UnaryOperator<VarPattern> visitIsAbstract(GraqlParser.IsAbstractContext ctx) {
        return VarPattern::isAbstract;
    }

    @Override
    public UnaryOperator<VarPattern> visitPropDatatype(GraqlParser.PropDatatypeContext ctx) {
        return var -> var.datatype(this.getDatatype(ctx.DATATYPE()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropRegex(GraqlParser.PropRegexContext ctx) {
        return var -> var.regex(this.getRegex(ctx.REGEX()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPropRel(GraqlParser.PropRelContext ctx) {
        return this.getVarProperties(ctx.casting());
    }

    @Override
    public UnaryOperator<VarPattern> visitPropNeq(GraqlParser.PropNeqContext ctx) {
        return var -> var.neq(this.visitVariable(ctx.variable()));
    }

    @Override
    public UnaryOperator<VarPattern> visitCasting(GraqlParser.CastingContext ctx) {
        if (ctx.VARIABLE() == null) {
            return var -> var.rel(this.visitVariable(ctx.variable()));
        }
        return var -> var.rel(this.visitVariable(ctx.variable()), (VarPattern)this.getVariable(ctx.VARIABLE()));
    }

    @Override
    public UnaryOperator<VarPattern> visitIsa(GraqlParser.IsaContext ctx) {
        return var -> var.isa(this.visitVariable(ctx.variable()));
    }

    @Override
    public UnaryOperator<VarPattern> visitSub(GraqlParser.SubContext ctx) {
        return var -> var.sub(this.visitVariable(ctx.variable()));
    }

    @Override
    public UnaryOperator<VarPattern> visitRelates(GraqlParser.RelatesContext ctx) {
        return var -> var.relates(this.visitVariable(ctx.variable()));
    }

    @Override
    public UnaryOperator<VarPattern> visitPlays(GraqlParser.PlaysContext ctx) {
        return var -> var.plays(this.visitVariable(ctx.variable()));
    }

    @Override
    public Label visitLabel(GraqlParser.LabelContext ctx) {
        return Label.of((String)this.visitIdentifier(ctx.identifier()));
    }

    @Override
    public ConceptId visitId(GraqlParser.IdContext ctx) {
        return ConceptId.of((String)this.visitIdentifier(ctx.identifier()));
    }

    @Override
    public String visitIdentifier(GraqlParser.IdentifierContext ctx) {
        if (ctx.STRING() != null) {
            return this.getString(ctx.STRING());
        }
        return ctx.getText();
    }

    @Override
    public VarPattern visitVariable(GraqlParser.VariableContext ctx) {
        if (ctx == null) {
            return Graql.var();
        }
        if (ctx.label() != null) {
            return Graql.label(this.visitLabel(ctx.label()));
        }
        return this.getVariable(ctx.VARIABLE());
    }

    @Override
    public ValuePredicate visitPredicateEq(GraqlParser.PredicateEqContext ctx) {
        return Graql.eq(this.visitValue(ctx.value()));
    }

    @Override
    public ValuePredicate visitPredicateVariable(GraqlParser.PredicateVariableContext ctx) {
        return Graql.eq((VarPattern)this.getVariable(ctx.VARIABLE()));
    }

    @Override
    public ValuePredicate visitPredicateNeq(GraqlParser.PredicateNeqContext ctx) {
        return this.applyPredicate(Graql::neq, Graql::neq, this.visitValueOrVar(ctx.valueOrVar()));
    }

    @Override
    public ValuePredicate visitPredicateGt(GraqlParser.PredicateGtContext ctx) {
        return this.applyPredicate(Graql::gt, Graql::gt, this.visitValueOrVar(ctx.valueOrVar()));
    }

    @Override
    public ValuePredicate visitPredicateGte(GraqlParser.PredicateGteContext ctx) {
        return this.applyPredicate(Graql::gte, Graql::gte, this.visitValueOrVar(ctx.valueOrVar()));
    }

    @Override
    public ValuePredicate visitPredicateLt(GraqlParser.PredicateLtContext ctx) {
        return this.applyPredicate(Graql::lt, Graql::lt, this.visitValueOrVar(ctx.valueOrVar()));
    }

    @Override
    public ValuePredicate visitPredicateLte(GraqlParser.PredicateLteContext ctx) {
        return this.applyPredicate(Graql::lte, Graql::lte, this.visitValueOrVar(ctx.valueOrVar()));
    }

    @Override
    public ValuePredicate visitPredicateContains(GraqlParser.PredicateContainsContext ctx) {
        String stringOrVar = ctx.STRING() != null ? this.getString(ctx.STRING()) : this.getVariable(ctx.VARIABLE());
        return this.applyPredicate(Graql::contains, Graql::contains, stringOrVar);
    }

    @Override
    public ValuePredicate visitPredicateRegex(GraqlParser.PredicateRegexContext ctx) {
        return Graql.regex(this.getRegex(ctx.REGEX()));
    }

    @Override
    public VarPattern visitValueVariable(GraqlParser.ValueVariableContext ctx) {
        return this.getVariable(ctx.VARIABLE());
    }

    @Override
    public String visitValueString(GraqlParser.ValueStringContext ctx) {
        return this.getString(ctx.STRING());
    }

    @Override
    public Long visitValueInteger(GraqlParser.ValueIntegerContext ctx) {
        return this.getInteger(ctx.INTEGER());
    }

    @Override
    public Double visitValueReal(GraqlParser.ValueRealContext ctx) {
        return Double.valueOf(ctx.REAL().getText());
    }

    @Override
    public Boolean visitValueBoolean(GraqlParser.ValueBooleanContext ctx) {
        return Boolean.valueOf(ctx.BOOLEAN().getText());
    }

    @Override
    public LocalDateTime visitValueDate(GraqlParser.ValueDateContext ctx) {
        return LocalDate.parse(ctx.DATE().getText(), DateTimeFormatter.ISO_LOCAL_DATE).atStartOfDay();
    }

    @Override
    public LocalDateTime visitValueDateTime(GraqlParser.ValueDateTimeContext ctx) {
        return LocalDateTime.parse(ctx.DATETIME().getText(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    private Match visitMatchPart(GraqlParser.MatchPartContext ctx) {
        return (Match)this.visit((ParseTree)ctx);
    }

    private Aggregate<?, ?> visitAggregate(GraqlParser.AggregateContext ctx) {
        return (Aggregate)this.visit((ParseTree)ctx);
    }

    public Pattern visitPattern(GraqlParser.PatternContext ctx) {
        return (Pattern)this.visit((ParseTree)ctx);
    }

    private ValuePredicate visitPredicate(GraqlParser.PredicateContext ctx) {
        return (ValuePredicate)this.visit((ParseTree)ctx);
    }

    private Object visitValueOrVar(GraqlParser.ValueOrVarContext ctx) {
        return this.visit((ParseTree)ctx);
    }

    private Object visitValue(GraqlParser.ValueContext ctx) {
        return this.visit((ParseTree)ctx);
    }

    private Var getVariable(TerminalNode variable) {
        return this.getVariable(variable.getSymbol());
    }

    private Var getVariable(Token variable) {
        return Graql.var(variable.getText().substring(1));
    }

    private String getRegex(TerminalNode string) {
        String unquoted = this.unquoteString(string);
        return unquoted.replaceAll("\\\\/", "/");
    }

    private String getString(TerminalNode string) {
        String unquoted = this.unquoteString(string);
        return StringUtil.unescapeString((String)unquoted);
    }

    private String unquoteString(TerminalNode string) {
        return string.getText().substring(1, string.getText().length() - 1);
    }

    private <T> UnaryOperator<T> compose(UnaryOperator<T> before, UnaryOperator<T> after) {
        return x -> after.apply(before.apply(x));
    }

    private <T> UnaryOperator<T> chainOperators(Stream<UnaryOperator<T>> operators) {
        return operators.reduce(UnaryOperator.identity(), this::compose);
    }

    private UnaryOperator<VarPattern> getVarProperties(List<? extends ParserRuleContext> contexts) {
        return this.chainOperators(contexts.stream().map(ctx -> (UnaryOperator)this.visit((ParseTree)ctx)));
    }

    private long getInteger(TerminalNode integer) {
        return Long.parseLong(integer.getText());
    }

    private Order getOrder(TerminalNode order) {
        if (order.getText().equals("asc")) {
            return Order.asc;
        }
        return Order.desc;
    }

    private <T> ValuePredicate applyPredicate(Function<T, ValuePredicate> valPred, Function<VarPattern, ValuePredicate> varPred, Object obj) {
        if (obj instanceof VarPattern) {
            return varPred.apply((VarPattern)obj);
        }
        return valPred.apply(obj);
    }

    private AttributeType.DataType getDatatype(TerminalNode datatype) {
        return (AttributeType.DataType)QueryParser.DATA_TYPES.get((Object)datatype.getText());
    }
}

