/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.AutoValue_ConjunctionImpl;
import ai.grakn.graql.internal.pattern.AutoValue_DisjunctionImpl;
import ai.grakn.graql.internal.pattern.AutoValue_VarPatternImpl;
import ai.grakn.graql.internal.pattern.VarImpl;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Patterns {
    private static final AtomicLong counter = new AtomicLong(System.currentTimeMillis() * 1000L);
    public static final Var RELATION_EDGE = Patterns.reservedVar("RELATION_EDGE");
    public static final Var RELATION_DIRECTION = Patterns.reservedVar("RELATION_DIRECTION");

    private Patterns() {
    }

    public static <T extends PatternAdmin> Conjunction<T> conjunction(Set<T> patterns) {
        return new AutoValue_ConjunctionImpl<T>(patterns);
    }

    public static <T extends PatternAdmin> Disjunction<T> disjunction(Set<T> patterns) {
        return new AutoValue_DisjunctionImpl<T>(patterns);
    }

    public static Var var() {
        return VarImpl.of(Long.toString(counter.getAndIncrement()), Var.Kind.Generated);
    }

    public static Var var(String value) {
        return VarImpl.of(value, Var.Kind.UserDefined);
    }

    public static VarPatternAdmin varPattern(Var name, Set<VarProperty> properties) {
        if (properties.isEmpty()) {
            return name.admin();
        }
        return new AutoValue_VarPatternImpl(name, properties);
    }

    private static Var reservedVar(String value) {
        return VarImpl.of(value, Var.Kind.Reserved);
    }
}

