/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknTx;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_HasResourceProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.reasoner.atom.binary.ResourceAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class HasResourceProperty
extends AbstractVarProperty
implements NamedProperty {
    public static final String NAME = "has";

    public static HasResourceProperty of(Label attributeType, VarPatternAdmin attribute, VarPatternAdmin relationship) {
        attribute = attribute.isa(Graql.label(attributeType)).admin();
        return new AutoValue_HasResourceProperty(attributeType, attribute, relationship);
    }

    public abstract Label type();

    public abstract VarPatternAdmin attribute();

    public abstract VarPatternAdmin relationship();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getProperty() {
        Stream.Builder<String> repr = Stream.builder();
        repr.add(StringConverter.typeLabelToString(this.type()));
        if (this.attribute().var().isUserDefinedName()) {
            repr.add(this.attribute().var().toString());
        } else {
            this.attribute().getProperties(ValueProperty.class).forEach(prop -> repr.add(prop.predicate().toString()));
        }
        if (this.hasReifiedRelationship()) {
            repr.add("as").add(this.relationship().getPrintableName());
        }
        return repr.build().collect(Collectors.joining(" "));
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        Var edge1 = Graql.var();
        Var edge2 = Graql.var();
        return ImmutableSet.of((Object)EquivalentFragmentSets.rolePlayer(this, this.relationship().var(), edge1, start, null), (Object)EquivalentFragmentSets.rolePlayer(this, this.relationship().var(), edge2, this.attribute().var(), null), (Object)EquivalentFragmentSets.neq(this, edge1, edge2));
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return Stream.of(this.attribute(), this.relationship());
    }

    @Override
    void checkValidProperty(GraknTx graph, VarPatternAdmin var) {
        SchemaConcept schemaConcept = graph.getSchemaConcept(this.type());
        if (schemaConcept == null || !schemaConcept.isAttributeType()) {
            throw GraqlQueryException.mustBeAttributeType((Label)this.type());
        }
    }

    @Override
    public PropertyExecutor insert(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Attribute attributeConcept = executor.get(this.attribute().var()).asAttribute();
            Thing thing = executor.get(var).asThing();
            ConceptId relationshipId = thing.attributeRelationship(attributeConcept).getId();
            executor.builder(this.relationship().var()).id(relationshipId);
        };
        return PropertyExecutor.builder(method).produces(this.relationship().var()).requires(var, this.attribute().var()).build();
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(Graql.label(this.type()).admin());
    }

    private boolean hasReifiedRelationship() {
        return this.relationship().getProperties().findAny().isPresent() || this.relationship().var().isUserDefinedName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasResourceProperty that = (HasResourceProperty)o;
        if (!this.type().equals(that.type())) {
            return false;
        }
        if (!this.attribute().equals(that.attribute())) {
            return false;
        }
        return !this.hasReifiedRelationship() || this.relationship().equals(that.relationship());
    }

    public int hashCode() {
        int result = this.type().hashCode();
        result = 31 * result + this.attribute().hashCode();
        if (this.hasReifiedRelationship()) {
            result = 31 * result + this.relationship().hashCode();
        }
        return result;
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.var().asUserDefined();
        Var relationVariable = this.relationship().var();
        Var attributeVariable = this.attribute().var().asUserDefined();
        Set<ValuePredicate> predicates = ReasonerUtils.getValuePredicates(attributeVariable, this.attribute(), vars, parent);
        IsaProperty isaProp = this.attribute().getProperties(IsaProperty.class).findFirst().orElse(null);
        VarPatternAdmin typeVar = isaProp != null ? isaProp.type() : null;
        IdPredicate idPredicate = typeVar != null ? ReasonerUtils.getIdPredicate(attributeVariable, typeVar, vars, parent) : null;
        VarPatternAdmin resVar = relationVariable.isUserDefinedName() ? varName.has(this.type(), (VarPattern)attributeVariable, (VarPattern)relationVariable).admin() : varName.has(this.type(), (VarPattern)attributeVariable).admin();
        return new ResourceAtom(resVar, attributeVariable, relationVariable, idPredicate, predicates, parent);
    }
}

