/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.reasoner.atom.property.IsAbstractAtom;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class IsAbstractProperty
extends AbstractVarProperty
implements UniqueVarProperty {
    private static final IsAbstractProperty INSTANCE = new IsAbstractProperty();
    public static final String NAME = "is-abstract";

    private IsAbstractProperty() {
    }

    public static IsAbstractProperty get() {
        return INSTANCE;
    }

    public void buildString(StringBuilder builder) {
        builder.append(NAME);
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.isAbstract(this, start));
    }

    @Override
    String getName() {
        return NAME;
    }

    @Override
    public PropertyExecutor define(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Concept concept = executor.get(var);
            if (!concept.isType()) {
                throw GraqlQueryException.insertAbstractOnNonType((SchemaConcept)concept.asSchemaConcept());
            }
            concept.asType().setAbstract(Boolean.valueOf(true));
        };
        return PropertyExecutor.builder(method).requires(var).build();
    }

    @Override
    public PropertyExecutor undefine(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Type type = executor.get(var).asType();
            if (!type.isDeleted()) {
                type.setAbstract(Boolean.valueOf(false));
            }
        };
        return PropertyExecutor.builder(method).requires(var).build();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        return new IsAbstractAtom(var.var(), parent);
    }
}

