/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_IsaProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.pattern.property.RelationshipProperty;
import ai.grakn.graql.internal.reasoner.atom.binary.type.IsaAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class IsaProperty
extends AbstractVarProperty
implements UniqueVarProperty,
NamedProperty {
    public static final String NAME = "isa";

    public static IsaProperty of(VarPatternAdmin type) {
        return new AutoValue_IsaProperty(Graql.var(), type);
    }

    public abstract Var directType();

    public abstract VarPatternAdmin type();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getProperty() {
        return this.type().getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.isa(this, start, this.directType(), true), (Object)EquivalentFragmentSets.sub(this, this.directType(), this.type().var()));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.type());
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return Stream.of(this.type());
    }

    @Override
    public PropertyExecutor insert(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Type type = executor.get(this.type().var()).asType();
            executor.builder(var).isa(type);
        };
        return PropertyExecutor.builder(method).requires(this.type().var()).produces(var).build();
    }

    @Override
    public void checkValidProperty(GraknTx graph, VarPatternAdmin var) throws GraqlQueryException {
        this.type().getTypeLabel().ifPresent(typeLabel -> {
            SchemaConcept theSchemaConcept = graph.getSchemaConcept(typeLabel);
            if (theSchemaConcept != null && theSchemaConcept.isRole()) {
                throw GraqlQueryException.queryInstanceOfRoleType((Label)typeLabel);
            }
        });
    }

    @Nullable
    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        if (var.hasProperty(RelationshipProperty.class)) {
            return null;
        }
        Var varName = var.var().asUserDefined();
        VarPatternAdmin typeVar = this.type();
        Var typeVariable = typeVar.var().asUserDefined();
        IdPredicate predicate = ReasonerUtils.getIdPredicate(typeVariable, typeVar, vars, parent);
        VarPatternAdmin isaVar = varName.isa((VarPattern)typeVariable).admin();
        return new IsaAtom(isaVar, typeVariable, predicate, parent);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IsaProperty) {
            IsaProperty that = (IsaProperty)o;
            return this.type().equals(that.type());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.type().hashCode();
    }
}

