/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.Role;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_PlaysProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.type.PlaysAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public abstract class PlaysProperty
extends AbstractVarProperty
implements NamedProperty {
    public static final String NAME = "plays";

    public static PlaysProperty of(VarPatternAdmin role, boolean required) {
        return new AutoValue_PlaysProperty(role, required);
    }

    abstract VarPatternAdmin role();

    abstract boolean required();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getProperty() {
        return this.role().getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.plays(this, start, this.role().var(), this.required()));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.role());
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return Stream.of(this.role());
    }

    @Override
    public PropertyExecutor define(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Role role = executor.get(this.role().var()).asRole();
            executor.get(var).asType().plays(role);
        };
        return PropertyExecutor.builder(method).requires(var, this.role().var()).build();
    }

    @Override
    public PropertyExecutor undefine(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Type type = executor.get(var).asType();
            Role role = executor.get(this.role().var()).asRole();
            if (!type.isDeleted() && !role.isDeleted()) {
                type.deletePlays(role);
            }
        };
        return PropertyExecutor.builder(method).requires(var, this.role().var()).build();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.var().asUserDefined();
        VarPatternAdmin typeVar = this.role();
        Var typeVariable = typeVar.var().asUserDefined();
        IdPredicate predicate = ReasonerUtils.getIdPredicate(typeVariable, typeVar, vars, parent);
        VarPatternAdmin resVar = varName.plays((VarPattern)typeVariable).admin();
        return new PlaysAtom(resVar, typeVariable, predicate, parent);
    }
}

