/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_RelatesProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.type.RelatesAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public abstract class RelatesProperty
extends AbstractVarProperty
implements NamedProperty {
    public static RelatesProperty of(VarPatternAdmin role) {
        return new AutoValue_RelatesProperty(role);
    }

    abstract VarPatternAdmin role();

    @Override
    public String getName() {
        return "relates";
    }

    @Override
    public String getProperty() {
        return this.role().getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.relates(this, start, this.role().var()));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.role());
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return Stream.of(this.role());
    }

    @Override
    public PropertyExecutor define(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Role role = executor.get(this.role().var()).asRole();
            executor.get(var).asRelationshipType().relates(role);
        };
        return PropertyExecutor.builder(method).requires(var, this.role().var()).build();
    }

    @Override
    public PropertyExecutor undefine(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            RelationshipType relationshipType = executor.get(var).asRelationshipType();
            Role role = executor.get(this.role().var()).asRole();
            if (!relationshipType.isDeleted() && !role.isDeleted()) {
                relationshipType.deleteRelates(role);
            }
        };
        return PropertyExecutor.builder(method).requires(var, this.role().var()).build();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.var().asUserDefined();
        VarPatternAdmin roleVar = this.role();
        Var roleVariable = roleVar.var().asUserDefined();
        IdPredicate rolePredicate = ReasonerUtils.getIdPredicate(roleVariable, roleVar, vars, parent);
        VarPatternAdmin hrVar = varName.relates((VarPattern)roleVariable).admin();
        return new RelatesAtom(hrVar, roleVariable, rolePredicate, parent);
    }
}

