/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.printer;

import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Var;
import ai.grakn.util.CommonUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mjson.Json;

class JsonPrinter
implements Printer<Json> {
    JsonPrinter() {
    }

    public final String build(Json builder) {
        return builder.toString();
    }

    public Json graqlString(boolean inner, Concept concept) {
        Json json = Json.object((Object[])new Object[]{"id", concept.getId().getValue()});
        if (concept.isSchemaConcept()) {
            json.set("name", (Object)concept.asSchemaConcept().getLabel().getValue());
            SchemaConcept superConcept = concept.asSchemaConcept().sup();
            if (superConcept != null) {
                json.set("sub", (Object)superConcept.getLabel().getValue());
            }
        } else if (concept.isThing()) {
            json.set("isa", (Object)concept.asThing().type().getLabel().getValue());
        } else {
            throw CommonUtil.unreachableStatement((String)("Unrecognised concept " + concept));
        }
        if (concept.isAttribute()) {
            json.set("value", concept.asAttribute().getValue());
        }
        if (concept.isRule()) {
            json.set("when", (Object)concept.asRule().getWhen().toString());
            json.set("then", (Object)concept.asRule().getThen().toString());
        }
        return json;
    }

    public final Json graqlString(boolean inner, boolean bool) {
        return Json.make((Object)bool);
    }

    public final Json graqlString(boolean inner, Optional<?> optional) {
        return optional.map(item -> (Json)this.graqlString(inner, item)).orElse(Json.nil());
    }

    public final Json graqlString(boolean inner, Collection<?> collection) {
        return Json.make(collection.stream().map(item -> (Json)this.graqlString(inner, item)).collect(Collectors.toList()));
    }

    public final Json graqlString(boolean inner, Map<?, ?> map) {
        Json json = Json.object();
        map.forEach((key, value) -> {
            if (key instanceof Var) {
                key = ((Var)key).getValue();
            }
            String keyString = key == null ? "" : key.toString();
            json.set(keyString, (Json)this.graqlString(true, value));
        });
        return json;
    }

    public final Json graqlStringDefault(boolean inner, Object object) {
        return Json.make((Object)object);
    }
}

