/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknTx;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.MatchAdmin;
import java.util.stream.Stream;

class AggregateQueryImpl<T>
implements AggregateQuery<T> {
    private final MatchAdmin match;
    private final Aggregate<? super Answer, T> aggregate;

    AggregateQueryImpl(MatchAdmin match, Aggregate<? super Answer, T> aggregate) {
        this.match = match;
        this.aggregate = aggregate;
    }

    public AggregateQuery<T> withTx(GraknTx tx) {
        return new AggregateQueryImpl<T>(this.match.withTx(tx).admin(), this.aggregate);
    }

    public T execute() {
        return (T)this.aggregate.apply(this.match.stream());
    }

    public Stream<String> resultsString(Printer printer) {
        return Stream.of(printer.graqlString(this.execute()));
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return this.match.toString() + " aggregate " + this.aggregate.toString() + ";";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateQueryImpl that = (AggregateQueryImpl)o;
        if (!this.match.equals(that.match)) {
            return false;
        }
        return this.aggregate.equals(that.aggregate);
    }

    public int hashCode() {
        int result = this.match.hashCode();
        result = 31 * result + this.aggregate.hashCode();
        return result;
    }
}

