/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.DeleteQueryAdmin;
import ai.grakn.graql.internal.query.AutoValue_DeleteQueryImpl;
import ai.grakn.graql.internal.query.Queries;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class DeleteQueryImpl
implements DeleteQueryAdmin {
    DeleteQueryImpl() {
    }

    abstract ImmutableCollection<Var> vars();

    public abstract Match match();

    static DeleteQueryImpl of(Collection<? extends Var> vars, Match match) {
        return new AutoValue_DeleteQueryImpl((ImmutableCollection<Var>)ImmutableSet.copyOf(vars), match);
    }

    public Void execute() {
        List<Answer> results = this.match().stream().collect(Collectors.toList());
        results.forEach(this::deleteResult);
        return null;
    }

    public Stream<String> resultsString(Printer printer) {
        this.execute();
        return Stream.empty();
    }

    public boolean isReadOnly() {
        return false;
    }

    public DeleteQuery withTx(GraknTx tx) {
        return Queries.delete(this.vars(), this.match().withTx(tx));
    }

    public DeleteQueryAdmin admin() {
        return this;
    }

    private void deleteResult(Answer result) {
        ImmutableCollection<Var> toDelete = this.vars().isEmpty() ? result.vars() : this.vars();
        for (Var var : toDelete) {
            Concept concept = result.get(var);
            if (concept.isSchemaConcept()) {
                throw GraqlQueryException.deleteSchemaConcept((SchemaConcept)concept.asSchemaConcept());
            }
            concept.delete();
        }
    }

    public String toString() {
        return this.match() + " delete " + this.vars().stream().map(v -> v + ";").collect(Collectors.joining("\n")).trim();
    }
}

