/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.DeleteQueryAdmin;
import ai.grakn.graql.admin.InsertQueryAdmin;
import ai.grakn.graql.admin.MatchAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.AggregateQueryImpl;
import ai.grakn.graql.internal.query.AutoValue_GetQueryImpl;
import ai.grakn.graql.internal.query.DeleteQueryImpl;
import ai.grakn.graql.internal.query.InsertQueryImpl;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public class Queries {
    private Queries() {
    }

    public static GetQuery get(ImmutableSet<Var> vars, MatchAdmin match) {
        Set selectedVars = match.getSelectedNames();
        for (Var var : vars) {
            if (selectedVars.contains(var)) continue;
            throw GraqlQueryException.varNotInQuery((Var)var);
        }
        return new AutoValue_GetQueryImpl(vars, (Match)match);
    }

    public static InsertQueryAdmin insert(ImmutableCollection<VarPatternAdmin> vars, MatchAdmin match) {
        return new InsertQueryImpl(vars, Optional.of(match), Optional.empty());
    }

    public static DeleteQueryAdmin delete(Collection<? extends Var> vars, Match match) {
        return DeleteQueryImpl.of(vars, match);
    }

    public static <T> AggregateQuery<T> aggregate(MatchAdmin match, Aggregate<? super Answer, T> aggregate) {
        return new AggregateQueryImpl<T>(match, aggregate);
    }
}

