/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.explanation.Explanation;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryAnswer
implements Answer {
    private final Map<Var, Concept> map = new HashMap<Var, Concept>();
    private AnswerExplanation explanation = new Explanation();

    public QueryAnswer() {
    }

    public QueryAnswer(Answer a) {
        this.map.putAll(a.map());
        this.explanation = a.getExplanation();
    }

    public QueryAnswer(Map<Var, Concept> m) {
        this.map.putAll(m);
    }

    public String toString() {
        return this.map.entrySet().stream().sorted(Comparator.comparing(e -> ((Var)e.getKey()).getValue())).map(e -> "[" + e.getKey() + "/" + ((Concept)e.getValue()).getId() + "]").collect(Collectors.joining());
    }

    public Answer copy() {
        return new QueryAnswer(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Answer)) {
            return false;
        }
        QueryAnswer a2 = (QueryAnswer)obj;
        return this.map.equals(a2.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public Set<Var> vars() {
        return this.map.keySet();
    }

    public Collection<Concept> values() {
        return this.map.values();
    }

    public Set<Concept> concepts() {
        return this.map.values().stream().collect(Collectors.toSet());
    }

    public Set<Map.Entry<Var, Concept>> entrySet() {
        return this.map.entrySet();
    }

    public Concept get(String var) {
        return this.get(Graql.var(var));
    }

    public Concept get(Var var) {
        Concept concept = this.map.get(var);
        if (concept == null) {
            throw GraqlQueryException.varNotInQuery((Var)var);
        }
        return concept;
    }

    public Concept put(Var var, Concept con) {
        return this.map.put(var, con);
    }

    public Concept remove(Var var) {
        return this.map.remove(var);
    }

    public Map<Var, Concept> map() {
        return this.map;
    }

    public void putAll(Answer a) {
        this.map.putAll(a.map());
    }

    public void putAll(Map<Var, Concept> m2) {
        this.map.putAll(m2);
    }

    public boolean containsKey(Var var) {
        return this.map.containsKey(var);
    }

    public boolean containsAll(Answer ans) {
        return this.map.entrySet().containsAll(ans.map().entrySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void forEach(BiConsumer<? super Var, ? super Concept> consumer) {
        this.map.forEach(consumer);
    }

    public Answer merge(Answer a2, boolean mergeExplanation) {
        if (a2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return a2;
        }
        AnswerExplanation exp = this.getExplanation();
        QueryAnswer merged = new QueryAnswer(this);
        merged.putAll(a2);
        if (mergeExplanation) {
            exp = exp.merge(a2.getExplanation());
            if (!this.getExplanation().isJoinExplanation()) {
                exp.addAnswer((Answer)this);
            }
            if (!a2.getExplanation().isJoinExplanation()) {
                exp.addAnswer(a2);
            }
        }
        return merged.setExplanation(exp);
    }

    public Answer merge(Answer a2) {
        return this.merge(a2, false);
    }

    public Answer explain(AnswerExplanation exp) {
        Set answers = this.explanation.getAnswers();
        this.explanation = exp;
        answers.forEach(arg_0 -> ((AnswerExplanation)this.explanation).addAnswer(arg_0));
        return this;
    }

    public Answer project(Set<Var> vars) {
        QueryAnswer filteredAnswer = new QueryAnswer(this);
        Sets.SetView varsToRemove = Sets.difference(this.vars(), vars);
        varsToRemove.forEach(filteredAnswer::remove);
        return filteredAnswer;
    }

    public Answer unify(Unifier unifier) {
        if (unifier.isEmpty()) {
            return this;
        }
        QueryAnswer unified = new QueryAnswer();
        for (Map.Entry<Var, Concept> e : this.entrySet()) {
            Var var = e.getKey();
            Concept con = e.getValue();
            Collection uvars = unifier.get(var);
            if (uvars.isEmpty() && !unifier.values().contains(var)) {
                Concept put = unified.put(var, con);
                if (put == null || put.equals(con)) continue;
                return new QueryAnswer();
            }
            for (Var uv : uvars) {
                Concept put = unified.put(uv, con);
                if (put == null || put.equals(con)) continue;
                return new QueryAnswer();
            }
        }
        return unified.setExplanation(this.getExplanation());
    }

    public Stream<Answer> unify(MultiUnifier multiUnifier) {
        return multiUnifier.stream().map(this::unify);
    }

    public Stream<Answer> expandHierarchies(Set<Var> toExpand) {
        if (toExpand.isEmpty()) {
            return Stream.of(this);
        }
        List entryOptions = this.entrySet().stream().map(e -> {
            Concept c;
            Var var = (Var)e.getKey();
            if (toExpand.contains(var) && (c = this.get(var)).isSchemaConcept()) {
                return ReasonerUtils.upstreamHierarchy(c.asSchemaConcept()).stream().map(r -> new Pair<Var, SchemaConcept>(var, (SchemaConcept)r)).collect(Collectors.toSet());
            }
            return Collections.singleton(new Pair<Var, Concept>(var, this.get(var)));
        }).collect(Collectors.toList());
        return Sets.cartesianProduct(entryOptions).stream().map(mappingList -> new QueryAnswer(mappingList.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue)))).map(ans -> ans.explain(this.getExplanation()));
    }

    public AnswerExplanation getExplanation() {
        return this.explanation;
    }

    public QueryAnswer setExplanation(AnswerExplanation e) {
        this.explanation = e;
        return this;
    }

    public Set<Answer> getExplicitPath() {
        return this.getAnswers().stream().filter(ans -> ans.getExplanation().isLookupExplanation()).collect(Collectors.toSet());
    }

    public Set<Answer> getAnswers() {
        HashSet answers = Sets.newHashSet((Object[])new Answer[]{this});
        this.getExplanation().getAnswers().forEach((? super T ans) -> ans.getAnswers().forEach(answers::add));
        return answers;
    }

    public Set<AnswerExplanation> getExplanations() {
        HashSet explanations = Sets.newHashSet((Object[])new AnswerExplanation[]{this.getExplanation()});
        this.getExplanation().getAnswers().forEach((? super T ans) -> ans.getExplanations().forEach(explanations::add));
        return explanations;
    }

    public Set<Atomic> toPredicates(ReasonerQuery parent) {
        Set varNames = parent.getVarNames();
        parent.getAtoms(TypeAtom.class).map(Binary::getPredicateVariable).forEach(varNames::remove);
        return this.entrySet().stream().filter(e -> varNames.contains(e.getKey())).map(e -> new IdPredicate((Var)e.getKey(), (Concept)e.getValue(), parent)).collect(Collectors.toSet());
    }
}

