/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.AutoValue_QueryOperationExecutor_VarAndProperty;
import ai.grakn.graql.internal.query.ConceptBuilder;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.util.Partition;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryOperationExecutor {
    private final GraknTx tx;
    private final Map<Var, Concept> concepts = new HashMap<Var, Concept>();
    private final Map<Var, ConceptBuilder> conceptBuilders = new HashMap<Var, ConceptBuilder>();
    private final ImmutableSet<VarAndProperty> properties;
    private final Partition<Var> equivalentVars;
    private final ImmutableMultimap<VarAndProperty, VarAndProperty> dependencies;
    private final ExecutionType executionType;

    private QueryOperationExecutor(GraknTx tx, ImmutableSet<VarAndProperty> properties, Partition<Var> equivalentVars, ImmutableMultimap<VarAndProperty, VarAndProperty> dependencies, ExecutionType executionType) {
        this.tx = tx;
        this.properties = properties;
        this.equivalentVars = equivalentVars;
        this.dependencies = dependencies;
        this.executionType = executionType;
    }

    static Answer insertAll(Collection<VarPatternAdmin> patterns, GraknTx graph) {
        return QueryOperationExecutor.create(patterns, graph, ExecutionType.INSERT).insertAll(new QueryAnswer());
    }

    static Answer insertAll(Collection<VarPatternAdmin> patterns, GraknTx graph, Answer results) {
        return QueryOperationExecutor.create(patterns, graph, ExecutionType.INSERT).insertAll(results);
    }

    static Answer defineAll(Collection<VarPatternAdmin> patterns, GraknTx graph) {
        return QueryOperationExecutor.create(patterns, graph, ExecutionType.DEFINE).insertAll(new QueryAnswer());
    }

    static void undefineAll(ImmutableList<VarPatternAdmin> patterns, GraknTx tx) {
        QueryOperationExecutor.create(patterns, tx, ExecutionType.UNDEFINE).insertAll(new QueryAnswer());
    }

    private static QueryOperationExecutor create(Collection<VarPatternAdmin> patterns, GraknTx graph, ExecutionType executionType) {
        ImmutableSet properties = (ImmutableSet)patterns.stream().flatMap(VarAndProperty::fromPattern).collect(CommonUtil.toImmutableSet());
        HashMultimap propDependencies = HashMultimap.create();
        for (VarAndProperty property : properties) {
            for (Var requiredVar : property.executor(executionType).requiredVars()) {
                propDependencies.put((Object)property, (Object)requiredVar);
            }
        }
        HashMultimap varDependencies = HashMultimap.create();
        for (VarAndProperty property : properties) {
            for (Var producedVar : property.executor(executionType).producedVars()) {
                varDependencies.put((Object)producedVar, (Object)property);
            }
        }
        Partition<Var> equivalentVars = Partition.singletons(Collections.emptyList());
        QueryOperationExecutor.equivalentProperties((Set<VarAndProperty>)properties).asMap().values().forEach(arg_0 -> QueryOperationExecutor.lambda$create$2((Multimap)varDependencies, equivalentVars, arg_0));
        Multimap dependencies = QueryOperationExecutor.composeMultimaps(propDependencies, varDependencies);
        return new QueryOperationExecutor(graph, (ImmutableSet<VarAndProperty>)properties, equivalentVars, (ImmutableMultimap<VarAndProperty, VarAndProperty>)ImmutableMultimap.copyOf(dependencies), executionType);
    }

    private static Multimap<VarProperty, Var> equivalentProperties(Set<VarAndProperty> properties) {
        HashMultimap equivalentProperties = HashMultimap.create();
        for (VarAndProperty varAndProperty : properties) {
            if (!varAndProperty.uniquelyIdentifiesConcept()) continue;
            equivalentProperties.put((Object)varAndProperty.property(), (Object)varAndProperty.var());
        }
        return equivalentProperties;
    }

    private static <K, T, V> Multimap<K, V> composeMultimaps(Multimap<K, T> map1, Multimap<T, V> map2) {
        HashMultimap composed = HashMultimap.create();
        for (Map.Entry entry1 : map1.entries()) {
            Object key = entry1.getKey();
            Object intermediateValue = entry1.getValue();
            for (Object value : map2.get(intermediateValue)) {
                composed.put(key, value);
            }
        }
        return composed;
    }

    private Answer insertAll(Answer results) {
        this.concepts.putAll(results.map());
        this.sortProperties().forEach(property -> ((VarAndProperty)property).executor(this.executionType).execute(this));
        this.conceptBuilders.forEach((var, builder) -> this.concepts.put((Var)var, builder.build()));
        ImmutableMap.Builder allConcepts = ImmutableMap.builder().putAll(this.concepts);
        for (Var var2 : this.equivalentVars.getNodes()) {
            allConcepts.put((Object)var2, (Object)this.concepts.get(this.equivalentVars.componentOf(var2)));
        }
        Map namedConcepts = Maps.filterKeys((Map)allConcepts.build(), Var::isUserDefinedName);
        return new QueryAnswer(namedConcepts);
    }

    private ImmutableList<VarAndProperty> sortProperties() {
        VarAndProperty property;
        ImmutableList.Builder sorted = ImmutableList.builder();
        HashMultimap dependencies = HashMultimap.create(this.dependencies);
        HashMultimap invertedDependencies = HashMultimap.create();
        Multimaps.invertFrom((Multimap)dependencies, (Multimap)invertedDependencies);
        ArrayDeque<VarAndProperty> propertiesWithoutDependencies = new ArrayDeque<VarAndProperty>(Sets.filter(this.properties, arg_0 -> QueryOperationExecutor.lambda$sortProperties$5((Multimap)dependencies, arg_0)));
        while ((property = (VarAndProperty)propertiesWithoutDependencies.poll()) != null) {
            sorted.add((Object)property);
            ArrayList dependents = Lists.newArrayList((Iterable)invertedDependencies.get((Object)property));
            for (VarAndProperty dependent : dependents) {
                dependencies.remove((Object)dependent, (Object)property);
                invertedDependencies.remove((Object)property, (Object)dependent);
                boolean hasNoDependencies = dependencies.get((Object)dependent).isEmpty();
                if (!hasNoDependencies) continue;
                propertiesWithoutDependencies.add(dependent);
            }
        }
        if (!dependencies.isEmpty()) {
            Var var = ((VarAndProperty)dependencies.keys().iterator().next()).var();
            throw GraqlQueryException.insertRecursive((VarPatternAdmin)this.printableRepresentation(var));
        }
        return sorted.build();
    }

    public ConceptBuilder builder(Var var) {
        return this.tryBuilder(var).orElseThrow(() -> {
            Concept concept = this.concepts.get(this.equivalentVars.componentOf(var));
            return GraqlQueryException.insertExistingConcept((VarPatternAdmin)this.printableRepresentation(var), (Concept)concept);
        });
    }

    public Optional<ConceptBuilder> tryBuilder(Var var) {
        if (this.concepts.containsKey(var = this.equivalentVars.componentOf(var))) {
            return Optional.empty();
        }
        ConceptBuilder builder = this.conceptBuilders.get(var);
        if (builder != null) {
            return Optional.of(builder);
        }
        builder = ConceptBuilder.of(this, var);
        this.conceptBuilders.put(var, builder);
        return Optional.of(builder);
    }

    public Concept get(Var var) {
        ConceptBuilder builder;
        Concept concept = this.concepts.get(var = this.equivalentVars.componentOf(var));
        if (concept == null && (builder = this.conceptBuilders.remove(var)) != null) {
            concept = builder.build();
            this.concepts.put(var, concept);
        }
        if (concept != null) {
            return concept;
        }
        throw GraqlQueryException.insertUndefinedVariable((VarPatternAdmin)this.printableRepresentation(var));
    }

    VarPatternAdmin printableRepresentation(Var var) {
        ImmutableSet.Builder propertiesOfVar = ImmutableSet.builder();
        for (VarAndProperty vp : this.properties) {
            if (!vp.var().equals((Object)var)) continue;
            propertiesOfVar.add((Object)vp.property());
        }
        return Patterns.varPattern(var, (Set<VarProperty>)propertiesOfVar.build());
    }

    GraknTx tx() {
        return this.tx;
    }

    private static /* synthetic */ boolean lambda$sortProperties$5(Multimap dependencies, VarAndProperty property) {
        return dependencies.get((Object)property).isEmpty();
    }

    private static /* synthetic */ void lambda$create$2(Multimap varDependencies, Partition equivalentVars, Collection vars) {
        Collection producers = vars.stream().flatMap(var -> varDependencies.get(var).stream()).collect(Collectors.toList());
        Var first = (Var)vars.iterator().next();
        vars.forEach(var -> {
            varDependencies.replaceValues(var, (Iterable)producers);
            equivalentVars.merge(first, var);
        });
    }

    private static enum ExecutionType {
        INSERT{

            @Override
            PropertyExecutor executor(VarPropertyInternal property, Var var) {
                return property.insert(var);
            }
        }
        ,
        DEFINE{

            @Override
            PropertyExecutor executor(VarPropertyInternal property, Var var) {
                return property.define(var);
            }
        }
        ,
        UNDEFINE{

            @Override
            PropertyExecutor executor(VarPropertyInternal property, Var var) {
                return property.undefine(var);
            }
        };


        abstract PropertyExecutor executor(VarPropertyInternal var1, Var var2);
    }

    static abstract class VarAndProperty {
        VarAndProperty() {
        }

        abstract Var var();

        abstract VarPropertyInternal property();

        static VarAndProperty of(Var var, VarProperty property) {
            return new AutoValue_QueryOperationExecutor_VarAndProperty(var, VarPropertyInternal.from(property));
        }

        static Stream<VarAndProperty> fromPattern(VarPatternAdmin pattern) {
            return pattern.getProperties().map(prop -> VarAndProperty.of(pattern.var(), prop));
        }

        private PropertyExecutor executor(ExecutionType executionType) {
            return executionType.executor(this.property(), this.var());
        }

        boolean uniquelyIdentifiesConcept() {
            return this.property().uniquelyIdentifiesConcept();
        }
    }
}

