/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

class StdAggregate
extends AbstractAggregate<Answer, Optional<Double>> {
    private final Var varName;

    StdAggregate(Var varName) {
        this.varName = varName;
    }

    public Optional<Double> apply(Stream<? extends Answer> stream) {
        Stream<Double> numStream = stream.map(result -> ((Number)result.get(this.varName).asAttribute().getValue()).doubleValue());
        Iterable data = numStream::iterator;
        long n = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            double delta = x - mean;
            double delta2 = x - (mean += delta / (double)(++n));
            M2 += delta * delta2;
        }
        if (n < 2L) {
            return Optional.empty();
        }
        return Optional.of(Math.sqrt(M2 / (double)(n - 1L)));
    }

    public String toString() {
        return "std " + this.varName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdAggregate that = (StdAggregate)o;
        return this.varName.equals((Object)that.varName);
    }

    public int hashCode() {
        return this.varName.hashCode();
    }
}

