/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import java.util.stream.Stream;

class SumAggregate
extends AbstractAggregate<Answer, Number> {
    private final Var varName;

    SumAggregate(Var varName) {
        this.varName = varName;
    }

    public Number apply(Stream<? extends Answer> stream) {
        return stream.map(result -> (Number)result.get(this.varName).asAttribute().getValue()).reduce(0, this::add);
    }

    private Number add(Number x, Number y) {
        if (x instanceof Long || y instanceof Long) {
            return x.longValue() + y.longValue();
        }
        return x.doubleValue() + y.doubleValue();
    }

    public String toString() {
        return "sum " + this.varName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SumAggregate that = (SumAggregate)o;
        return this.varName.equals((Object)that.varName);
    }

    public int hashCode() {
        return this.varName.hashCode();
    }
}

