/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

abstract class AbstractStatisticsQuery<T>
extends AbstractComputeQuery<T> {
    Set<Label> statisticsResourceLabels = new HashSet<Label>();
    Set<Type> statisticsResourceTypes = new HashSet<Type>();

    AbstractStatisticsQuery() {
    }

    AbstractStatisticsQuery<T> setStatisticsResourceType(String ... statisticsResourceTypeLabels) {
        this.statisticsResourceLabels = Arrays.stream(statisticsResourceTypeLabels).map(Label::of).collect(Collectors.toSet());
        return this;
    }

    AbstractStatisticsQuery<T> setStatisticsResourceType(Collection<Label> statisticsResourceLabels) {
        this.statisticsResourceLabels = Sets.newHashSet(statisticsResourceLabels);
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    void initSubGraph() {
        super.initSubGraph();
        this.getResourceTypes((GraknTx)this.tx.get());
    }

    @Override
    final String graqlString() {
        return this.getName() + this.resourcesString() + this.subtypeString();
    }

    abstract String getName();

    private String resourcesString() {
        return " of " + this.statisticsResourceLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", "));
    }

    private void getResourceTypes(GraknTx graph) {
        if (this.statisticsResourceLabels.isEmpty()) {
            throw GraqlQueryException.statisticsResourceTypesNotSpecified();
        }
        this.statisticsResourceTypes = this.statisticsResourceLabels.stream().map(label -> {
            Type type = (Type)graph.getSchemaConcept(label);
            if (type == null) {
                throw GraqlQueryException.labelNotFound((Label)label);
            }
            if (!type.isAttributeType()) {
                throw GraqlQueryException.mustBeAttributeType((Label)type.getLabel());
            }
            return type;
        }).flatMap(Type::subs).collect(Collectors.toSet());
        this.statisticsResourceLabels = this.statisticsResourceTypes.stream().map(SchemaConcept::getLabel).collect(Collectors.toSet());
    }

    @Nullable
    AttributeType.DataType getDataTypeOfSelectedResourceTypes() {
        AttributeType.DataType dataType = null;
        for (Type type : this.statisticsResourceTypes) {
            if (!type.isAttributeType()) {
                throw GraqlQueryException.mustBeAttributeType((Label)type.getLabel());
            }
            AttributeType resourceType = (AttributeType)type;
            if (dataType == null) {
                dataType = resourceType.getDataType();
                if (dataType.equals(AttributeType.DataType.LONG) || dataType.equals(AttributeType.DataType.DOUBLE)) continue;
                throw GraqlQueryException.resourceMustBeANumber((AttributeType.DataType)dataType, (Label)resourceType.getLabel());
            }
            if (dataType.equals(resourceType.getDataType())) continue;
            throw GraqlQueryException.resourcesWithDifferentDataTypes(this.statisticsResourceLabels);
        }
        return dataType;
    }

    boolean selectedResourceTypesHaveInstance(Set<Label> statisticsResourceTypes) {
        for (Label resourceType : statisticsResourceTypes) {
            for (Label type : this.subLabels) {
                Boolean patternExist = ((GraknTx)this.tx.get()).graql().infer(false).match(new Pattern[]{Graql.var("x").has(resourceType, (VarPattern)Graql.var()), Graql.var("x").isa(Graql.label(type))}).iterator().hasNext();
                if (!patternExist.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    Set<Label> getCombinedSubTypes() {
        Set<Label> allSubTypes = AbstractStatisticsQuery.getHasResourceRelationLabels(this.statisticsResourceTypes);
        allSubTypes.addAll(this.subLabels);
        allSubTypes.addAll(this.statisticsResourceLabels);
        return allSubTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractStatisticsQuery that = (AbstractStatisticsQuery)o;
        return this.statisticsResourceLabels.equals(that.statisticsResourceLabels);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.statisticsResourceLabels.hashCode();
        return result;
    }
}

