/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.ClusterQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.ClusterSizeMapReduce;
import ai.grakn.graql.internal.analytics.ConnectedComponentVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class ClusterQueryImpl<T>
extends AbstractComputeQuery<T>
implements ClusterQuery<T> {
    private boolean members = false;
    private boolean anySize = true;
    private long clusterSize = -1L;

    ClusterQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public T execute() {
        LOGGER.info("ConnectedComponentsVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.info("Selected types don't have instances");
            return (T)Collections.emptyMap();
        }
        Set<Label> withResourceRelationTypes = ClusterQueryImpl.getHasResourceRelationLabels(this.subTypes);
        withResourceRelationTypes.addAll(this.subLabels);
        String randomId = ClusterQueryImpl.getRandomJobId();
        Set<LabelId> withResourceRelationLabelIds = this.convertLabelsToIds(withResourceRelationTypes);
        if (this.members) {
            ComputerResult result = this.anySize ? this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(randomId), (MapReduce)new ClusterMemberMapReduce("connectedComponentVertexProgram.clusterLabel" + randomId), withResourceRelationLabelIds) : this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(randomId), (MapReduce)new ClusterMemberMapReduce("connectedComponentVertexProgram.clusterLabel" + randomId, this.clusterSize), withResourceRelationLabelIds);
            LOGGER.info("ConnectedComponentsVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
            return (T)result.memory().get(ClusterMemberMapReduce.class.getName());
        }
        ComputerResult result = this.anySize ? this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(randomId), (MapReduce)new ClusterSizeMapReduce("connectedComponentVertexProgram.clusterLabel" + randomId), withResourceRelationLabelIds) : this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(randomId), (MapReduce)new ClusterSizeMapReduce("connectedComponentVertexProgram.clusterLabel" + randomId, this.clusterSize), withResourceRelationLabelIds);
        LOGGER.info("ConnectedComponentsVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return (T)result.memory().get(ClusterSizeMapReduce.class.getName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public ClusterQuery<Map<String, Set<String>>> members() {
        this.members = true;
        return this;
    }

    public ClusterQuery<T> clusterSize(long clusterSize) {
        this.anySize = false;
        this.clusterSize = clusterSize;
        return this;
    }

    @Override
    public ClusterQuery<T> in(String ... subTypeLabels) {
        return (ClusterQuery)super.in(subTypeLabels);
    }

    @Override
    public ClusterQuery<T> in(Collection<Label> subLabels) {
        return (ClusterQuery)super.in(subLabels);
    }

    @Override
    String graqlString() {
        String string = "cluster" + this.subtypeString();
        if (this.members) {
            string = string + " members;";
        }
        if (!this.anySize) {
            string = string + " size " + this.clusterSize + ";";
        }
        return string;
    }

    @Override
    public ClusterQuery<T> withTx(GraknTx tx) {
        return (ClusterQuery)super.withTx(tx);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterQueryImpl that = (ClusterQueryImpl)o;
        return this.members == that.members && this.anySize == that.anySize && this.clusterSize == that.clusterSize;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.members ? 1 : 0);
        result = 31 * result + (this.anySize ? 1 : 0);
        result = 31 * result + (int)(this.clusterSize ^ this.clusterSize >>> 32);
        return result;
    }
}

