/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.CountQuery;
import ai.grakn.graql.internal.analytics.CountMapReduce;
import ai.grakn.graql.internal.analytics.CountVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class CountQueryImpl
extends AbstractComputeQuery<Long>
implements CountQuery {
    CountQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Long execute() {
        LOGGER.info("CountMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.debug("Count = 0");
            LOGGER.info("CountMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
            return 0L;
        }
        Set<LabelId> rolePlayerLabelIds = this.getRolePlayerLabelIds();
        Set<LabelId> typeLabelIds = this.convertLabelsToIds(this.subLabels);
        rolePlayerLabelIds.addAll(typeLabelIds);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new CountVertexProgram(), (MapReduce)new CountMapReduce(), rolePlayerLabelIds, Boolean.valueOf(false));
        Map count = (Map)result.memory().get(CountMapReduce.class.getName());
        long finalCount = count.keySet().stream().filter(id -> typeLabelIds.contains(LabelId.of((Integer)id))).mapToLong(count::get).sum();
        if (count.containsKey(-10)) {
            finalCount += ((Long)count.get(-10)).longValue();
        }
        LOGGER.debug("Count = " + finalCount);
        LOGGER.info("CountMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return finalCount;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CountQuery in(String ... subTypeLabels) {
        return (CountQuery)super.in(subTypeLabels);
    }

    public CountQuery in(Collection<Label> subLabels) {
        return (CountQuery)super.in(subLabels);
    }

    @Override
    String graqlString() {
        return "count" + this.subtypeString();
    }

    public CountQuery withTx(GraknTx tx) {
        return (CountQuery)super.withTx(tx);
    }
}

