/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.DegreeQuery;
import ai.grakn.graql.internal.analytics.DegreeDistributionMapReduce;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class DegreeQueryImpl
extends AbstractComputeQuery<Map<Long, Set<String>>>
implements DegreeQuery {
    private boolean ofTypeLabelsSet = false;
    private Set<Label> ofLabels = new HashSet<Label>();

    DegreeQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Map<Long, Set<String>> execute() {
        LOGGER.info("DegreeVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        if (this.ofLabels.isEmpty()) {
            this.ofLabels.addAll(this.subLabels);
        } else {
            this.ofLabels = this.ofLabels.stream().flatMap(typeLabel -> {
                Type type = (Type)((GraknTx)this.tx.get()).getSchemaConcept(typeLabel);
                if (type == null) {
                    throw GraqlQueryException.labelNotFound((Label)typeLabel);
                }
                return type.subs();
            }).map(SchemaConcept::getLabel).collect(Collectors.toSet());
            this.subLabels.addAll(this.ofLabels);
        }
        if (!this.selectedTypesHaveInstance()) {
            return Collections.emptyMap();
        }
        Set<Label> withResourceRelationTypes = DegreeQueryImpl.getHasResourceRelationLabels(this.subTypes);
        withResourceRelationTypes.addAll(this.subLabels);
        Set<LabelId> withResourceRelationLabelIds = this.convertLabelsToIds(withResourceRelationTypes);
        Set<LabelId> ofLabelIds = this.convertLabelsToIds(this.ofLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(ofLabelIds), (MapReduce)new DegreeDistributionMapReduce(ofLabelIds, "degreeVertexProgram.degree"), withResourceRelationLabelIds);
        LOGGER.info("DegreeVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return (Map)result.memory().get(DegreeDistributionMapReduce.class.getName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public DegreeQuery in(String ... subTypeLabels) {
        return (DegreeQuery)super.in(subTypeLabels);
    }

    public DegreeQuery in(Collection<Label> subLabels) {
        return (DegreeQuery)super.in(subLabels);
    }

    public DegreeQuery of(String ... ofTypeLabels) {
        if (ofTypeLabels.length > 0) {
            this.ofTypeLabelsSet = true;
            this.ofLabels = Arrays.stream(ofTypeLabels).map(Label::of).collect(Collectors.toSet());
        }
        return this;
    }

    public DegreeQuery of(Collection<Label> ofLabels) {
        if (!ofLabels.isEmpty()) {
            this.ofTypeLabelsSet = true;
            this.ofLabels = Sets.newHashSet(ofLabels);
        }
        return this;
    }

    @Override
    String graqlString() {
        String string = "degrees";
        if (this.ofTypeLabelsSet) {
            string = string + " of " + this.ofLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", "));
        }
        string = string + this.subtypeString();
        return string;
    }

    public DegreeQuery withTx(GraknTx tx) {
        return (DegreeQuery)super.withTx(tx);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DegreeQueryImpl that = (DegreeQueryImpl)o;
        return this.ofTypeLabelsSet == that.ofTypeLabelsSet && this.ofLabels.equals(that.ofLabels);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ofTypeLabelsSet ? 1 : 0);
        result = 31 * result + this.ofLabels.hashCode();
        return result;
    }
}

