/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.MaxQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.MaxMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MaxQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MaxQuery {
    MaxQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MaxMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        AttributeType.DataType dataType = this.getDataTypeOfSelectedResourceTypes();
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceLabels)) {
            return Optional.empty();
        }
        Set<LabelId> allSubLabelIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<LabelId> statisticsResourceLabelIds = this.convertLabelsToIds(this.statisticsResourceLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(statisticsResourceLabelIds), (MapReduce)new MaxMapReduce(statisticsResourceLabelIds, dataType, "degreeVertexProgram.degree"), allSubLabelIds);
        Map max = (Map)result.memory().get(MaxMapReduce.class.getName());
        LOGGER.debug("Max = " + max.get(MapReduce.NullObject.instance()));
        LOGGER.info("MaxMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(max.get(MapReduce.NullObject.instance()));
    }

    public MaxQuery of(String ... resourceTypeLabels) {
        return (MaxQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MaxQuery of(Collection<Label> resourceLabels) {
        return (MaxQuery)this.setStatisticsResourceType(resourceLabels);
    }

    public MaxQuery in(String ... subTypeLabels) {
        return (MaxQuery)super.in(subTypeLabels);
    }

    public MaxQuery in(Collection<Label> subLabels) {
        return (MaxQuery)super.in(subLabels);
    }

    public MaxQuery withTx(GraknTx tx) {
        return (MaxQuery)super.withTx(tx);
    }

    @Override
    String getName() {
        return "max";
    }
}

