/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.MeanQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.MeanMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MeanQueryImpl
extends AbstractStatisticsQuery<Optional<Double>>
implements MeanQuery {
    MeanQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<Double> execute() {
        LOGGER.info("MeanMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        AttributeType.DataType dataType = this.getDataTypeOfSelectedResourceTypes();
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceLabels)) {
            return Optional.empty();
        }
        Set<LabelId> allSubLabelIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<LabelId> statisticsResourceLabelIds = this.convertLabelsToIds(this.statisticsResourceLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(statisticsResourceLabelIds), (MapReduce)new MeanMapReduce(statisticsResourceLabelIds, dataType, "degreeVertexProgram.degree"), allSubLabelIds);
        Map mean = (Map)result.memory().get(MeanMapReduce.class.getName());
        Map meanPair = (Map)mean.get(MapReduce.NullObject.instance());
        double finalResult = (Double)meanPair.get("S") / (Double)meanPair.get("C");
        LOGGER.debug("Mean = " + finalResult);
        LOGGER.info("MeanMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public MeanQuery of(String ... resourceTypeLabels) {
        return (MeanQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MeanQuery of(Collection<Label> resourceLabels) {
        return (MeanQuery)this.setStatisticsResourceType(resourceLabels);
    }

    public MeanQuery in(String ... subTypeLabels) {
        return (MeanQuery)super.in(subTypeLabels);
    }

    public MeanQuery in(Collection<Label> subLabels) {
        return (MeanQuery)super.in(subLabels);
    }

    public MeanQuery withTx(GraknTx tx) {
        return (MeanQuery)super.withTx(tx);
    }

    @Override
    String getName() {
        return "mean";
    }
}

