/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.MedianQuery;
import ai.grakn.graql.internal.analytics.MedianVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MedianQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MedianQuery {
    MedianQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MedianVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        AttributeType.DataType dataType = this.getDataTypeOfSelectedResourceTypes();
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceLabels)) {
            return Optional.empty();
        }
        Set<LabelId> allSubLabelIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<LabelId> statisticsResourceLabelIds = this.convertLabelsToIds(this.statisticsResourceLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new MedianVertexProgram(statisticsResourceLabelIds, dataType), null, allSubLabelIds);
        Number finalResult = (Number)result.memory().get("medianVertexProgram.median");
        LOGGER.debug("Median = " + finalResult);
        LOGGER.info("MedianVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public MedianQuery of(String ... resourceTypeLabels) {
        return (MedianQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MedianQuery of(Collection<Label> resourceLabels) {
        return (MedianQuery)this.setStatisticsResourceType(resourceLabels);
    }

    public MedianQuery in(String ... subTypeLabels) {
        return (MedianQuery)super.in(subTypeLabels);
    }

    public MedianQuery in(Collection<Label> subLabels) {
        return (MedianQuery)super.in(subLabels);
    }

    public MedianQuery withTx(GraknTx tx) {
        return (MedianQuery)super.withTx(tx);
    }

    @Override
    String getName() {
        return "median";
    }
}

