/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.graql.internal.analytics.ShortestPathVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class PathQueryImpl
extends AbstractComputeQuery<Optional<List<Concept>>>
implements PathQuery {
    private ConceptId sourceId = null;
    private ConceptId destinationId = null;

    PathQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<List<Concept>> execute() {
        ComputerResult result;
        LOGGER.info("ShortestPathVertexProgram is called");
        long startTime = System.currentTimeMillis();
        if (this.sourceId == null) {
            throw GraqlQueryException.noPathSource();
        }
        if (this.destinationId == null) {
            throw GraqlQueryException.noPathDestination();
        }
        this.initSubGraph();
        if (!this.verticesExistInSubgraph(this.sourceId, this.destinationId)) {
            throw GraqlQueryException.instanceDoesNotExist();
        }
        if (this.sourceId.equals(this.destinationId)) {
            return Optional.of(Collections.singletonList(((GraknTx)this.tx.get()).getConcept(this.sourceId)));
        }
        Set<LabelId> subLabelIds = this.convertLabelsToIds(this.subLabels);
        try {
            result = this.getGraphComputer().compute((VertexProgram)new ShortestPathVertexProgram(this.sourceId, this.destinationId), (MapReduce)new ClusterMemberMapReduce("shortestPathVertexProgram.foundInIteration"), subLabelIds);
        }
        catch (NoResultException e) {
            LOGGER.info("ShortestPathVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
            return Optional.empty();
        }
        Map map = (Map)result.memory().get(ClusterMemberMapReduce.class.getName());
        String middlePoint = (String)result.memory().get("shortestPathVertexProgram.middle");
        if (!middlePoint.equals("")) {
            map.put(0, Collections.singleton(middlePoint));
        }
        ArrayList<ConceptId> path = new ArrayList<ConceptId>();
        path.add(this.sourceId);
        path.addAll(map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(pair -> ConceptId.of((String)((String)((Set)pair.getValue()).iterator().next()))).collect(Collectors.toList()));
        path.add(this.destinationId);
        ArrayList fullPath = new ArrayList();
        for (int index = 0; index < path.size() - 1; ++index) {
            fullPath.add(path.get(index));
            ConceptId resourceRelationId = Utility.getResourceEdgeId((GraknTx)this.tx.get(), (ConceptId)path.get(index), (ConceptId)path.get(index + 1));
            if (resourceRelationId == null) continue;
            fullPath.add(resourceRelationId);
        }
        fullPath.add(this.destinationId);
        LOGGER.debug("The path found is: " + fullPath);
        LOGGER.info("ShortestPathVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(fullPath.stream().map(arg_0 -> ((GraknTx)((GraknTx)this.tx.get())).getConcept(arg_0)).collect(Collectors.toList()));
    }

    public PathQuery from(ConceptId sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public PathQuery to(ConceptId destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    public PathQuery in(String ... subTypeLabels) {
        return (PathQuery)super.in(subTypeLabels);
    }

    public PathQuery in(Collection<Label> subLabels) {
        return (PathQuery)super.in(subLabels);
    }

    @Override
    String graqlString() {
        return "path from " + StringConverter.idToString(this.sourceId) + " to " + StringConverter.idToString(this.destinationId) + this.subtypeString();
    }

    public PathQuery withTx(GraknTx tx) {
        return (PathQuery)super.withTx(tx);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathQueryImpl pathQuery = (PathQueryImpl)o;
        if (!this.sourceId.equals(pathQuery.sourceId)) {
            return false;
        }
        return this.destinationId.equals(pathQuery.destinationId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sourceId.hashCode();
        result = 31 * result + this.destinationId.hashCode();
        return result;
    }
}

