/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.StdQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.StdMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class StdQueryImpl
extends AbstractStatisticsQuery<Optional<Double>>
implements StdQuery {
    StdQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<Double> execute() {
        LOGGER.info("StdMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        AttributeType.DataType dataType = this.getDataTypeOfSelectedResourceTypes();
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceLabels)) {
            return Optional.empty();
        }
        Set<LabelId> allSubLabelIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<LabelId> statisticsResourceLabelIds = this.convertLabelsToIds(this.statisticsResourceLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(statisticsResourceLabelIds), (MapReduce)new StdMapReduce(statisticsResourceLabelIds, dataType, "degreeVertexProgram.degree"), allSubLabelIds);
        Map std = (Map)result.memory().get(StdMapReduce.class.getName());
        Map stdTuple = (Map)std.get(MapReduce.NullObject.instance());
        double squareSum = (Double)stdTuple.get("SM");
        double sum = (Double)stdTuple.get("S");
        double count = (Double)stdTuple.get("C");
        double finalResult = Math.sqrt(squareSum / count - sum / count * (sum / count));
        LOGGER.debug("Std = " + finalResult);
        LOGGER.info("StdMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public StdQuery of(String ... resourceTypeLabels) {
        return (StdQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public StdQuery of(Collection<Label> resourceLabels) {
        return (StdQuery)this.setStatisticsResourceType(resourceLabels);
    }

    public StdQuery in(String ... subTypeLabels) {
        return (StdQuery)super.in(subTypeLabels);
    }

    public StdQuery in(Collection<Label> subLabels) {
        return (StdQuery)super.in(subLabels);
    }

    public StdQuery withTx(GraknTx tx) {
        return (StdQuery)super.withTx(tx);
    }

    @Override
    String getName() {
        return "std";
    }
}

